/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.internal.options;

import io.delta.flink.internal.options.BaseOptionTypeConverter;
import io.delta.flink.internal.options.DeltaConfigOption;
import io.delta.flink.internal.options.OptionType;

public class BooleanOptionTypeConverter
extends BaseOptionTypeConverter<Boolean> {
    @Override
    public <T> T convertType(DeltaConfigOption<T> deltaConfigOption, String string) {
        Class<T> clazz = deltaConfigOption.getValueType();
        OptionType optionType = OptionType.instanceFrom(clazz);
        if (optionType == OptionType.BOOLEAN) {
            if ("true".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string)) {
                return (T)Boolean.valueOf(string);
            }
            throw this.invalidValueException(deltaConfigOption.key(), string);
        }
        throw new IllegalArgumentException(String.format("BooleanOptionTypeConverter used with a incompatible DeltaConfigOption option type. This converter must be used only for DeltaConfigOption::Boolean however it was used for '%s' with option '%s'", deltaConfigOption.getValueType(), deltaConfigOption.key()));
    }

    private IllegalArgumentException invalidValueException(String string, String string2) {
        return new IllegalArgumentException(String.format("Illegal value used for [%s] option. Expected values \"true\" or \"false\" keywords (case insensitive) or boolean true, false values. Used value was [%s]", string, string2));
    }
}

