/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.connector.sqlserver.Module;
import io.debezium.connector.sqlserver.SqlServerChangeEventSourceCoordinator;
import io.debezium.connector.sqlserver.SqlServerChangeEventSourceFactory;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.SqlServerDatabaseSchema;
import io.debezium.connector.sqlserver.SqlServerErrorHandler;
import io.debezium.connector.sqlserver.SqlServerEventMetadataProvider;
import io.debezium.connector.sqlserver.SqlServerOffsetContext;
import io.debezium.connector.sqlserver.SqlServerPartition;
import io.debezium.connector.sqlserver.SqlServerTaskContext;
import io.debezium.connector.sqlserver.SqlServerTopicSelector;
import io.debezium.connector.sqlserver.SqlServerValueConverters;
import io.debezium.connector.sqlserver.metrics.SqlServerMetricsFactory;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.metrics.DefaultChangeEventSourceMetricsFactory;
import io.debezium.pipeline.metrics.spi.ChangeEventSourceMetricsFactory;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.relational.TableId;
import io.debezium.relational.ValueConverterProvider;
import io.debezium.schema.DataCollectionFilters;
import io.debezium.schema.DatabaseSchema;
import io.debezium.schema.TopicSelector;
import io.debezium.util.Clock;
import io.debezium.util.SchemaNameAdjuster;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerConnectorTask
extends BaseSourceTask<SqlServerPartition, SqlServerOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlServerConnectorTask.class);
    private static final String CONTEXT_NAME = "sql-server-connector-task";
    private volatile SqlServerTaskContext taskContext;
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile SqlServerConnection dataConnection;
    private volatile SqlServerConnection metadataConnection;
    private volatile ErrorHandler errorHandler;
    private volatile SqlServerDatabaseSchema schema;

    public String version() {
        return Module.version();
    }

    public ChangeEventSourceCoordinator<SqlServerPartition, SqlServerOffsetContext> start(Configuration config) {
        Clock clock = Clock.system();
        config = ((Configuration.Builder)config.edit().withDefault("database.responseBuffering", "adaptive").withDefault("database.fetchSize", 10000)).build();
        SqlServerConnectorConfig connectorConfig = new SqlServerConnectorConfig(config);
        TopicSelector<TableId> topicSelector = SqlServerTopicSelector.defaultSelector(connectorConfig);
        SchemaNameAdjuster schemaNameAdjuster = connectorConfig.schemaNameAdjustmentMode().createAdjuster();
        SqlServerValueConverters valueConverters = new SqlServerValueConverters(connectorConfig.getDecimalMode(), connectorConfig.getTemporalPrecisionMode(), connectorConfig.binaryHandlingMode());
        this.dataConnection = new SqlServerConnection(connectorConfig.getJdbcConfig(), connectorConfig.getSourceTimestampMode(), valueConverters, () -> ((Object)((Object)this)).getClass().getClassLoader(), connectorConfig.getSkippedOperations(), connectorConfig.isMultiPartitionModeEnabled(), connectorConfig.getOptionRecompile());
        this.metadataConnection = new SqlServerConnection(connectorConfig.getJdbcConfig(), connectorConfig.getSourceTimestampMode(), valueConverters, () -> ((Object)((Object)this)).getClass().getClassLoader(), connectorConfig.getSkippedOperations(), connectorConfig.isMultiPartitionModeEnabled());
        this.schema = new SqlServerDatabaseSchema(connectorConfig, this.metadataConnection.getDefaultValueConverter(), (ValueConverterProvider)valueConverters, topicSelector, schemaNameAdjuster);
        this.schema.initializeStorage();
        Offsets offsets = this.getPreviousOffsets(new SqlServerPartition.Provider(connectorConfig, config), new SqlServerOffsetContext.Loader(connectorConfig));
        this.schema.recover(offsets);
        this.taskContext = new SqlServerTaskContext(connectorConfig, this.schema);
        this.queue = new ChangeEventQueue.Builder().pollInterval(connectorConfig.getPollInterval()).maxBatchSize(connectorConfig.getMaxBatchSize()).maxQueueSize(connectorConfig.getMaxQueueSize()).maxQueueSizeInBytes(connectorConfig.getMaxQueueSizeInBytes()).loggingContextSupplier(() -> this.taskContext.configureLoggingContext(CONTEXT_NAME)).build();
        this.errorHandler = new SqlServerErrorHandler(connectorConfig, this.queue);
        SqlServerEventMetadataProvider metadataProvider = new SqlServerEventMetadataProvider();
        EventDispatcher dispatcher = new EventDispatcher((CommonConnectorConfig)connectorConfig, topicSelector, (DatabaseSchema)this.schema, this.queue, (DataCollectionFilters.DataCollectionFilter)connectorConfig.getTableFilters().dataCollectionFilter(), DataChangeEvent::new, (EventMetadataProvider)metadataProvider, schemaNameAdjuster);
        SqlServerChangeEventSourceCoordinator coordinator = new SqlServerChangeEventSourceCoordinator((Offsets<SqlServerPartition, SqlServerOffsetContext>)offsets, this.errorHandler, (Class<? extends SourceConnector>)SqlServerConnector.class, (CommonConnectorConfig)connectorConfig, new SqlServerChangeEventSourceFactory(connectorConfig, this.dataConnection, this.metadataConnection, this.errorHandler, (EventDispatcher<SqlServerPartition, TableId>)dispatcher, clock, this.schema), this.createChangeEventSourceMetricsFactory(connectorConfig.isMultiPartitionModeEnabled(), (Offsets<SqlServerPartition, SqlServerOffsetContext>)offsets), (EventDispatcher<SqlServerPartition, ?>)dispatcher, (DatabaseSchema<?>)this.schema, clock);
        coordinator.start(this.taskContext, (ChangeEventQueueMetrics)this.queue, metadataProvider);
        return coordinator;
    }

    public List<SourceRecord> doPoll() throws InterruptedException {
        List records = this.queue.poll();
        List<SourceRecord> sourceRecords = records.stream().map(DataChangeEvent::getRecord).collect(Collectors.toList());
        return sourceRecords;
    }

    protected void doStop() {
        try {
            if (this.dataConnection != null) {
                this.dataConnection.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("Exception while closing JDBC connection", (Throwable)e);
        }
        try {
            if (this.metadataConnection != null) {
                this.metadataConnection.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("Exception while closing JDBC metadata connection", (Throwable)e);
        }
        if (this.schema != null) {
            this.schema.close();
        }
    }

    protected Iterable<Field> getAllConfigurationFields() {
        return SqlServerConnectorConfig.ALL_FIELDS;
    }

    private ChangeEventSourceMetricsFactory<SqlServerPartition> createChangeEventSourceMetricsFactory(boolean multiPartitionMode, Offsets<SqlServerPartition, SqlServerOffsetContext> offsets) {
        if (multiPartitionMode) {
            return new SqlServerMetricsFactory(offsets.getPartitions());
        }
        return new DefaultChangeEventSourceMetricsFactory();
    }
}

