/* Quark 1.0.452 run at 2016-10-24 14:33:24.783025 */
package quark.test;

public class Functions {

    static datawire_mdk_md.Root root = new datawire_mdk_md.Root();


    public static String red(String str) {
        return (("\u001b[31;1m") + (str)) + ("\u001b[0m");
    }


    public static String green(String str) {
        return (("\u001b[32;1m") + (str)) + ("\u001b[0m");
    }


    public static String bold(String str) {
        return (("\u001b[1m") + (str)) + ("\u001b[0m");
    }


    public static String heading(String str) {
        String padding = "=";
        Integer target_width = 78;
        String res = (((padding) + (" ")) + (str)) + (" ");
        Integer count = ~((~((target_width) - ((res).length()))) / ((padding).length()));
        String block = new String(new char[Math.max(0, (~((~(count)) / (2))))]).replace("\0", (padding));
        String extra = "";
        if ((io.datawire.quark.runtime.Builtins.modulo((count), (2)))==(1) || ((Object)(io.datawire.quark.runtime.Builtins.modulo((count), (2))) != null && ((Object) (io.datawire.quark.runtime.Builtins.modulo((count), (2)))).equals(1))) {
            extra = padding;
        }
        return Functions.bold(((((block) + (res)) + (block)) + (extra)).trim());
    }


    public static Boolean check(Boolean value, String message) {
        return (Test.current()).check(value, message);
    }


    public static Boolean checkEqual(Object expected, Object actual) {
        return (Test.current()).check((expected)==(actual) || ((Object)(expected) != null && ((Object) (expected)).equals(actual)), ((("expected ") + (("" + (expected)))) + (" got ")) + (("" + (actual))));
    }


    public static void fail(String message) {
        (Test.current()).check(false, message);
    }


    public static Boolean checkOneOf(java.util.ArrayList<Object> expected, Object actual) {
        String message = "Expected one of [";
        Integer idx = 0;
        Boolean success = false;
        while ((idx) < ((expected).size())) {
            if (!((idx)==(0) || ((Object)(idx) != null && ((Object) (idx)).equals(0)))) {
                message = (message) + (", ");
            }
            message = (message) + (("" + ((expected).get(idx))));
            if (((expected).get(idx))==(actual) || ((Object)((expected).get(idx)) != null && ((Object) ((expected).get(idx))).equals(actual))) {
                success = true;
            }
            idx = (idx) + (1);
        }
        message = ((message) + ("] got ")) + (("" + (actual)));
        return Functions.check(success, message);
    }


    public static Integer testPackages(java.util.ArrayList<String> packages, java.util.ArrayList<String> filters, Boolean emitJson) {
        Harness h = new Harness("");
        Integer total_failures = 0;
        Integer idx = 0;
        while ((idx) < ((packages).size())) {
            (h).pkg = (packages).get(idx);
            (h).collect(filters);
            idx = (idx) + (1);
        }
        total_failures = (h).run();
        if (emitJson) {
            (h).json_report();
        }
        return total_failures;
    }


    public static void run(java.util.ArrayList<String> args) {
        ((quark.logging.Functions.makeConfig()).setLevel("INFO")).configure();
        String pkg = (args).get(0);
        java.util.ArrayList<String> filters = new java.util.ArrayList(java.util.Arrays.asList(new Object[]{}));
        Boolean qlist = false;
        Boolean json = false;
        Integer idx = 1;
        while ((idx) < ((args).size())) {
            String arg = (args).get(idx);
            if ((arg)==("-l") || ((Object)(arg) != null && ((Object) (arg)).equals("-l"))) {
                qlist = true;
            } else {
                if ((arg)==("--json") || ((Object)(arg) != null && ((Object) (arg)).equals("--json"))) {
                    json = true;
                } else {
                    if ((arg)==("--unsafe") || ((Object)(arg) != null && ((Object) (arg)).equals("--unsafe"))) {
                        SafeMethodCaller.useSafeCalls = false;
                    } else {
                        (filters).add(arg);
                    }
                }
            }
            idx = (idx) + (1);
        }
        if (qlist) {
            Harness h = new Harness(pkg);
            (h).collect(filters);
            (h).list();
        } else {
            do{System.out.println(Functions.bold(("Running: ") + (io.datawire.quark.runtime.Builtins.join((" "), (args)))));System.out.flush();}while(false);
            Integer failures = Functions.testPackages(new java.util.ArrayList(java.util.Arrays.asList(new Object[]{pkg})), filters, json);
            if ((failures) > (0)) {
                (quark.concurrent.Context.runtime()).fail("Test run failed.");
            }
        }
    }
}
