/* Quark 1.0.452 run at 2016-10-24 14:33:24.783025 */
package quark.os;

/**
 * Class for interacting with the process environment
 */
public class Environment implements io.datawire.quark.runtime.QObject {
    /**
     * Singleton for interacting with the process environment
     */
    public static Environment ENV = new Environment();
    public static quark.reflect.Class quark_os_Environment_ref = datawire_mdk_md.Root.quark_os_Environment_md;
    public Environment() {}
    /**
     * Retrieve the Environment singleton
     */
    public static Environment getEnvironment() {
        return Environment.ENV;
    }
    /**
     * Fetch the value of an environment variable.
     * Returns null if the variable is not set.
     */
    public String __get__(String key) {
        return System.getenv(key);
    }
    /**
     * Fetch the value of an environment variable.
     * Returns the specified default if the variable is not set.
     */
    public String get(String key, String default_value) {
        String value = System.getenv(key);
        if ((value)==(null) || ((Object)(value) != null && ((Object) (value)).equals(null))) {
            return default_value;
        }
        return value;
    }
    /**
     * Fetch the value of $USER
     */
    public static String getUser() {
        return System.getenv("USER");
    }
    public String _getClass() {
        return "quark.os.Environment";
    }
    public Object _getField(String name) {
        if ((name)==("ENV") || ((Object)(name) != null && ((Object) (name)).equals("ENV"))) {
            return Environment.ENV;
        }
        return null;
    }
    public void _setField(String name, Object value) {
        if ((name)==("ENV") || ((Object)(name) != null && ((Object) (name)).equals("ENV"))) {
            Environment.ENV = (Environment) (value);
        }
    }
}
