/* Quark 1.0.452 run at 2016-10-24 14:33:24.783025 */
package quark.mock;

public class MockRuntime implements quark.Runtime, io.datawire.quark.runtime.QObject {
    public static quark.reflect.Class quark_List_quark_mock_MockEvent__ref = datawire_mdk_md.Root.quark_List_quark_mock_MockEvent__md;
    public static quark.reflect.Class quark_List_quark_mock_MockTask__ref = datawire_mdk_md.Root.quark_List_quark_mock_MockTask__md;
    public static quark.reflect.Class quark_List_quark_bool__ref = datawire_mdk_md.Root.quark_List_quark_bool__md;
    public static quark.reflect.Class quark_mock_MockRuntime_ref = datawire_mdk_md.Root.quark_mock_MockRuntime_md;
    public quark.Runtime runtime;
    public java.util.ArrayList<MockEvent> events = new java.util.ArrayList(java.util.Arrays.asList(new Object[]{}));
    public java.util.ArrayList<MockTask> tasks = new java.util.ArrayList(java.util.Arrays.asList(new Object[]{}));
    public java.util.ArrayList<Boolean> _executed_tasks = new java.util.ArrayList(java.util.Arrays.asList(new Object[]{}));
    public Integer executed = 0;
    public Long _currentTime = 1000000L;
    public MockRuntime(quark.Runtime runtime) {
        (this).runtime = runtime;
    }
    /**
     * Execute all currently scheduled tasks.
     */
    public void pump() {
        Integer size = (this.tasks).size();
        Integer idx = 0;
        while ((idx) < (size)) {
            if ((this._executed_tasks).get(idx)) {
                idx = (idx) + (1);
                continue;
            }
            MockTask wrapper = (this.tasks).get(idx);
            quark.Task next = ((this.tasks).get(idx)).task;
            if (((wrapper)._scheduledFor) <= ((this).now())) {
                (this._executed_tasks).set((idx), (true));
                (next).onExecute(this);
                this.executed = (this.executed) + (1);
            }
            idx = (idx) + (1);
        }
    }
    public void open(String url, quark.WSHandler handler) {
        (this.events).add(new SocketEvent(url, handler));
    }
    public void request(quark.HTTPRequest request, quark.HTTPHandler handler) {
        (this.events).add(new RequestEvent(request, handler));
    }
    public void schedule(quark.Task handler, Double delayInSeconds) {
        MockTask task = new MockTask(handler, delayInSeconds);
        (task)._scheduledFor = ((this).now()) + (Math.round((1000.0) * (delayInSeconds)));
        (this.tasks).add(task);
        (this._executed_tasks).add(false);
    }
    public io.datawire.quark.runtime.Codec codec() {
        return (this.runtime).codec();
    }
    public Long now() {
        return this._currentTime;
    }
    public void advanceClock(Long ms) {
        this._currentTime = (this._currentTime) + (ms);
    }
    public void sleep(Double seconds) {
        (this.runtime).sleep(seconds);
    }
    public String uuid() {
        return (this.runtime).uuid();
    }
    public void serveHTTP(String url, quark.HTTPServlet servlet) {
        (this.runtime).fail("Runtime.serveHTTP not yet supported by the MockRuntime");
    }
    public void serveWS(String url, quark.WSServlet servlet) {
        (this.runtime).fail("Runtime.serveWS not yet supported by the MockRuntime");
    }
    public void respond(quark.HTTPRequest request, quark.HTTPResponse response) {
        (this.runtime).fail("Runtime.respond not yet supported by the MockRuntime");
    }
    public void fail(String message) {
        (this.runtime).fail(message);
    }
    public io.datawire.quark.runtime.Logger logger(String topic) {
        return (this.runtime).logger(topic);
    }
    public Object callSafely(quark.UnaryCallable callee, Object defaultResult) {
        return (callee).call(null);
    }
    public String _getClass() {
        return "quark.mock.MockRuntime";
    }
    public Object _getField(String name) {
        if ((name)==("runtime") || ((Object)(name) != null && ((Object) (name)).equals("runtime"))) {
            return (this).runtime;
        }
        if ((name)==("events") || ((Object)(name) != null && ((Object) (name)).equals("events"))) {
            return (this).events;
        }
        if ((name)==("tasks") || ((Object)(name) != null && ((Object) (name)).equals("tasks"))) {
            return (this).tasks;
        }
        if ((name)==("_executed_tasks") || ((Object)(name) != null && ((Object) (name)).equals("_executed_tasks"))) {
            return (this)._executed_tasks;
        }
        if ((name)==("executed") || ((Object)(name) != null && ((Object) (name)).equals("executed"))) {
            return (this).executed;
        }
        if ((name)==("_currentTime") || ((Object)(name) != null && ((Object) (name)).equals("_currentTime"))) {
            return (this)._currentTime;
        }
        return null;
    }
    public void _setField(String name, Object value) {
        if ((name)==("runtime") || ((Object)(name) != null && ((Object) (name)).equals("runtime"))) {
            (this).runtime = (quark.Runtime) (value);
        }
        if ((name)==("events") || ((Object)(name) != null && ((Object) (name)).equals("events"))) {
            (this).events = (java.util.ArrayList<MockEvent>) (value);
        }
        if ((name)==("tasks") || ((Object)(name) != null && ((Object) (name)).equals("tasks"))) {
            (this).tasks = (java.util.ArrayList<MockTask>) (value);
        }
        if ((name)==("_executed_tasks") || ((Object)(name) != null && ((Object) (name)).equals("_executed_tasks"))) {
            (this)._executed_tasks = (java.util.ArrayList<Boolean>) (value);
        }
        if ((name)==("executed") || ((Object)(name) != null && ((Object) (name)).equals("executed"))) {
            (this).executed = (Integer) (value);
        }
        if ((name)==("_currentTime") || ((Object)(name) != null && ((Object) (name)).equals("_currentTime"))) {
            (this)._currentTime = (Long) (value);
        }
    }
}
