/* Quark 1.0.452 run at 2016-10-24 14:33:24.783025 */
package quark.logging;

public class Functions {

    static datawire_mdk_md.Root root = new datawire_mdk_md.Root();


    /**
     * Logging appender that sends log messages to standard output
     */
    public static Appender stdout() {
        return new Appender(":STDOUT");
    }


    /**
     * Logging appender that sends log messages to standard error
     */
    public static Appender stderr() {
        return new Appender(":STDERR");
    }


    /**
     * Logging appender that sends log messages to a file
     */
    public static Appender file(String path) {
        return new Appender(path);
    }


    /**
     * Set an environment variable to override logging set up in the code
     */
    public static void setEnvironmentOverride(String envVar, String level) {
        Config._overrideEnvVar = envVar;
        Config._overrideLevel = level;
    }


    /**
     * Create a logging configurator
     */
    public static Config makeConfig() {
        return new Config();
    }
}
