/* Quark 1.0.452 run at 2016-10-24 14:33:24.783025 */
package quark.logging;

/**
 * Logging configurator
 */
public class Config implements io.datawire.quark.runtime.QObject {
    public static String _overrideEnvVar = "QUARK_TRACE";
    public static String _overrideLevel = "DEBUG";
    public static Boolean _configured = false;
    public static quark.reflect.Class quark_logging_Config_ref = datawire_mdk_md.Root.quark_logging_Config_md;
    public Appender appender = Functions.stderr();
    public String level = "INFO";
    public Config() {}
    /**
     * Set the destination for logging, default stderr()
     */
    public Config setAppender(Appender appender) {
        (this).appender = appender;
        return this;
    }
    /**
     * set the logging level [trace|debug|info|warn|error], default 'info'
     */
    public Config setLevel(String level) {
        (this).level = level;
        return this;
    }
    public static String _getOverrideIfExists() {
        if ((Config._overrideEnvVar)==(null) || ((Object)(Config._overrideEnvVar) != null && ((Object) (Config._overrideEnvVar)).equals(null))) {
            return (String) (null);
        }
        String envVarValue = System.getenv(Config._overrideEnvVar);
        if (((((envVarValue)==(null) || ((Object)(envVarValue) != null && ((Object) (envVarValue)).equals(null))) || ((envVarValue)==("") || ((Object)(envVarValue) != null && ((Object) (envVarValue)).equals("")))) || ((envVarValue)==("0") || ((Object)(envVarValue) != null && ((Object) (envVarValue)).equals("0")))) || (((envVarValue).toLowerCase())==("false") || ((Object)((envVarValue).toLowerCase()) != null && ((Object) ((envVarValue).toLowerCase())).equals("false")))) {
            return (String) (null);
        }
        return envVarValue;
    }
    public static Boolean _autoconfig() {
        return (!(Config._configured)) && (!((Config._getOverrideIfExists())==(null) || ((Object)(Config._getOverrideIfExists()) != null && ((Object) (Config._getOverrideIfExists())).equals(null))));
    }
    /**
     * Configure the logging
     */
    public void configure() {
        String envVarValue = Config._getOverrideIfExists();
        if (!((envVarValue)==(null) || ((Object)(envVarValue) != null && ((Object) (envVarValue)).equals(null)))) {
            if (((envVarValue)==("1") || ((Object)(envVarValue) != null && ((Object) (envVarValue)).equals("1"))) || (((envVarValue).toLowerCase())==("true") || ((Object)((envVarValue).toLowerCase()) != null && ((Object) ((envVarValue).toLowerCase())).equals("true")))) {
                this.appender = Functions.stderr();
            } else {
                this.appender = Functions.file(envVarValue);
            }
            this.level = Config._overrideLevel;
        }
        io.datawire.quark.runtime.LoggerConfig.configureLogging((this.appender), (this.level));
        Config._configured = true;
    }
    public String _getClass() {
        return "quark.logging.Config";
    }
    public Object _getField(String name) {
        if ((name)==("_overrideEnvVar") || ((Object)(name) != null && ((Object) (name)).equals("_overrideEnvVar"))) {
            return Config._overrideEnvVar;
        }
        if ((name)==("_overrideLevel") || ((Object)(name) != null && ((Object) (name)).equals("_overrideLevel"))) {
            return Config._overrideLevel;
        }
        if ((name)==("_configured") || ((Object)(name) != null && ((Object) (name)).equals("_configured"))) {
            return Config._configured;
        }
        if ((name)==("appender") || ((Object)(name) != null && ((Object) (name)).equals("appender"))) {
            return (this).appender;
        }
        if ((name)==("level") || ((Object)(name) != null && ((Object) (name)).equals("level"))) {
            return (this).level;
        }
        return null;
    }
    public void _setField(String name, Object value) {
        if ((name)==("_overrideEnvVar") || ((Object)(name) != null && ((Object) (name)).equals("_overrideEnvVar"))) {
            Config._overrideEnvVar = (String) (value);
        }
        if ((name)==("_overrideLevel") || ((Object)(name) != null && ((Object) (name)).equals("_overrideLevel"))) {
            Config._overrideLevel = (String) (value);
        }
        if ((name)==("_configured") || ((Object)(name) != null && ((Object) (name)).equals("_configured"))) {
            Config._configured = (Boolean) (value);
        }
        if ((name)==("appender") || ((Object)(name) != null && ((Object) (name)).equals("appender"))) {
            (this).appender = (Appender) (value);
        }
        if ((name)==("level") || ((Object)(name) != null && ((Object) (name)).equals("level"))) {
            (this).level = (String) (value);
        }
    }
}
