/* Quark 1.0.452 run at 2016-10-24 14:33:24.783025 */
package quark;

public interface WSHandler {
    public static quark.reflect.Class quark_WSHandler_ref = datawire_mdk_md.Root.quark_WSHandler_md;
    /**
     * Called when the WebSocket is first created.
     */
     void onWSInit(WebSocket socket);
    /**
     * Called when the WebSocket connects successfully.
     */
     void onWSConnected(WebSocket socket);
    /**
     * Called when the WebSocket receives a message.
     */
     void onWSMessage(WebSocket socket, String message);
    /**
     * Called when the WebSocket receives a binary message.
     */
     void onWSBinary(WebSocket socket, io.datawire.quark.runtime.Buffer message);
    /**
     * Called when the WebSocket disconnects cleanly.
     */
     void onWSClosed(WebSocket socket);
    /**
     * Called when the WebSocket disconnects with an error, or fails to connect.
     */
     void onWSError(WebSocket socket, WSError error);
    /**
     * Called when the WebSocket is done with life, one way or another.
     */
     void onWSFinal(WebSocket socket);
}
