/* Quark 1.0.452 run at 2016-10-24 14:33:24.783025 */
package quark;

/**
 * An object that will eventually have a result.
 * Results are passed to callables whose return value is passed
 * to resulting Promise. If a return result is a Promise it will
 * be chained automatically, i.e. callables will never be called
 * with a Promise, only with values.
 */
public class Promise implements io.datawire.quark.runtime.QObject {
    public static quark.reflect.Class quark_List_quark__Callback__ref = datawire_mdk_md.Root.quark_List_quark__Callback__md;
    public static quark.reflect.Class quark_Promise_ref = datawire_mdk_md.Root.quark_Promise_md;
    public io.datawire.quark.runtime.Lock _lock;
    public Object _successResult;
    public quark.error.Error _failureResult;
    public Boolean _hasResult;
    public java.util.ArrayList<_Callback> _successCallbacks;
    public java.util.ArrayList<_Callback> _failureCallbacks;
    public Promise() {
        (this)._lock = new io.datawire.quark.runtime.Lock();
        (this)._hasResult = false;
        (this)._successResult = null;
        (this)._failureResult = (quark.error.Error) (null);
        (this)._successCallbacks = new java.util.ArrayList(java.util.Arrays.asList(new Object[]{}));
        (this)._failureCallbacks = new java.util.ArrayList(java.util.Arrays.asList(new Object[]{}));
    }
    public void _maybeRunCallbacks() {
        ((this)._lock).acquire();
        if (!((this)._hasResult)) {
            ((this)._lock).release();
            return;
        }
        java.util.ArrayList<_Callback> callbacks = (this)._successCallbacks;
        Object value = (this)._successResult;
        if (!(((this)._failureResult)==(null) || ((Object)((this)._failureResult) != null && ((Object) ((this)._failureResult)).equals(null)))) {
            callbacks = (this)._failureCallbacks;
            value = (this)._failureResult;
        }
        (this)._failureCallbacks = new java.util.ArrayList(java.util.Arrays.asList(new Object[]{}));
        (this)._successCallbacks = new java.util.ArrayList(java.util.Arrays.asList(new Object[]{}));
        ((this)._lock).release();
        Integer idx = 0;
        while ((idx) < ((callbacks).size())) {
            ((callbacks).get(idx)).call(value);
            idx = (idx) + (1);
        }
    }
    public void _resolve(Object result) {
        if ((quark.reflect.Class.ERROR).hasInstance(result)) {
            (this)._reject((quark.error.Error) (result));
            return;
        }
        ((this)._lock).acquire();
        if ((this)._hasResult) {
            do{System.out.println("BUG: Resolved Promise that already has a value.");System.out.flush();}while(false);
            ((this)._lock).release();
            return;
        }
        (this)._hasResult = true;
        (this)._successResult = result;
        ((this)._lock).release();
        (this)._maybeRunCallbacks();
    }
    public void _reject(quark.error.Error err) {
        ((this)._lock).acquire();
        if ((this)._hasResult) {
            do{System.out.println("BUG: Rejected Promise that already has a value.");System.out.flush();}while(false);
            ((this)._lock).release();
            return;
        }
        (this)._hasResult = true;
        (this)._failureResult = err;
        ((this)._lock).release();
        (this)._maybeRunCallbacks();
    }
    /**
     * Add callback that will be called on non-Error values.
     * Its result will become the value of the returned Promise.
     */
    public Promise andThen(UnaryCallable callable) {
        Promise result = new Promise();
        ((this)._lock).acquire();
        ((this)._successCallbacks).add(new _Callback(callable, result));
        ((this)._failureCallbacks).add(new _Callback(new _Passthrough(), result));
        ((this)._lock).release();
        (this)._maybeRunCallbacks();
        return result;
    }
    /**
     * Add callback that will be called on Error values.
     * Its result will become the value of the returned Promise.
     */
    public Promise andCatch(quark.reflect.Class errorClass, UnaryCallable callable) {
        Promise result = new Promise();
        _Callback callback = new _Callback(new _CallIfIsInstance(callable, errorClass), result);
        ((this)._lock).acquire();
        ((this)._failureCallbacks).add(callback);
        ((this)._successCallbacks).add(new _Callback(new _Passthrough(), result));
        ((this)._lock).release();
        (this)._maybeRunCallbacks();
        return result;
    }
    /**
     * Two callbacks, one for success and one for error results.
     */
    public Promise andEither(UnaryCallable success, UnaryCallable failure) {
        Promise result = new Promise();
        ((this)._lock).acquire();
        ((this)._successCallbacks).add(new _Callback(success, result));
        ((this)._failureCallbacks).add(new _Callback(failure, result));
        ((this)._lock).release();
        (this)._maybeRunCallbacks();
        return result;
    }
    /**
     * Callback that will be called for both success and error results.
     */
    public Promise andFinally(UnaryCallable callable) {
        return this.andEither(callable, callable);
    }
    /**
     * Synchronous extraction of the promise's current value, if it has any.
     * Its result will become the value of the returned Promise.
     */
    public PromiseValue value() {
        ((this)._lock).acquire();
        PromiseValue result = new PromiseValue((this)._successResult, (this)._failureResult, (this)._hasResult);
        ((this)._lock).release();
        return result;
    }
    public String _getClass() {
        return "quark.Promise";
    }
    public Object _getField(String name) {
        if ((name)==("_lock") || ((Object)(name) != null && ((Object) (name)).equals("_lock"))) {
            return (this)._lock;
        }
        if ((name)==("_successResult") || ((Object)(name) != null && ((Object) (name)).equals("_successResult"))) {
            return (this)._successResult;
        }
        if ((name)==("_failureResult") || ((Object)(name) != null && ((Object) (name)).equals("_failureResult"))) {
            return (this)._failureResult;
        }
        if ((name)==("_hasResult") || ((Object)(name) != null && ((Object) (name)).equals("_hasResult"))) {
            return (this)._hasResult;
        }
        if ((name)==("_successCallbacks") || ((Object)(name) != null && ((Object) (name)).equals("_successCallbacks"))) {
            return (this)._successCallbacks;
        }
        if ((name)==("_failureCallbacks") || ((Object)(name) != null && ((Object) (name)).equals("_failureCallbacks"))) {
            return (this)._failureCallbacks;
        }
        return null;
    }
    public void _setField(String name, Object value) {
        if ((name)==("_lock") || ((Object)(name) != null && ((Object) (name)).equals("_lock"))) {
            (this)._lock = (io.datawire.quark.runtime.Lock) (value);
        }
        if ((name)==("_successResult") || ((Object)(name) != null && ((Object) (name)).equals("_successResult"))) {
            (this)._successResult = value;
        }
        if ((name)==("_failureResult") || ((Object)(name) != null && ((Object) (name)).equals("_failureResult"))) {
            (this)._failureResult = (quark.error.Error) (value);
        }
        if ((name)==("_hasResult") || ((Object)(name) != null && ((Object) (name)).equals("_hasResult"))) {
            (this)._hasResult = (Boolean) (value);
        }
        if ((name)==("_successCallbacks") || ((Object)(name) != null && ((Object) (name)).equals("_successCallbacks"))) {
            (this)._successCallbacks = (java.util.ArrayList<_Callback>) (value);
        }
        if ((name)==("_failureCallbacks") || ((Object)(name) != null && ((Object) (name)).equals("_failureCallbacks"))) {
            (this)._failureCallbacks = (java.util.ArrayList<_Callback>) (value);
        }
    }
}
