/* Quark 1.0.452 run at 2016-10-24 14:33:24.783025 */
package quark;

/**
 * Promise-based I/O and scheduling APIs.
 */
public class IO implements io.datawire.quark.runtime.QObject {
    public static quark.reflect.Class quark_IO_ref = datawire_mdk_md.Root.quark_IO_md;
    public IO() {}
    /**
     * Send a HTTP request, get back Promise that gets HTTPResponse or HTTPError result.
     */
    public static Promise httpRequest(HTTPRequest request) {
        PromiseFactory factory = new PromiseFactory();
        (quark.concurrent.Context.runtime()).request(request, new _IOHTTPHandler(factory));
        return (factory).promise;
    }
    /**
     * Schedule a callable to run in the future, return Promise with null result.
     */
    public static Promise schedule(Double delayInSeconds) {
        PromiseFactory factory = new PromiseFactory();
        (quark.concurrent.Context.runtime()).schedule(new _IOScheduleTask(factory), delayInSeconds);
        return (factory).promise;
    }
    public String _getClass() {
        return "quark.IO";
    }
    public Object _getField(String name) {
        return null;
    }
    public void _setField(String name, Object value) {}
}
