/* Quark 1.0.452 run at 2016-10-24 14:33:24.783025 */
package quark;

public class Functions {

    static datawire_mdk_md.Root root = new datawire_mdk_md.Root();


    /**
     * Get epoch time in milliseconds
     */
    public static Long now() {
        return (quark.concurrent.Context.runtime()).now();
    }


    /**
     * Suspend execution of this thread for some number of seconds
     */
    public static void sleep(Double seconds) {
        (quark.concurrent.Context.runtime()).sleep(seconds);
    }


    /**
     * Get a v4 random UUID (Universally Unique IDentifier)
     */
    public static String uuid() {
        return (quark.concurrent.Context.runtime()).uuid();
    }


    /**
     * Allow native code to call UnaryCallables.
     */
    public static Object callUnaryCallable(UnaryCallable callee, Object arg) {
        return (callee).call(arg);
    }


    public static io.datawire.quark.runtime.Logger _getLogger(String topic) {
        if (quark.logging.Config._autoconfig()) {
            (quark.logging.Functions.makeConfig()).configure();
        }
        return (quark.concurrent.Context.runtime()).logger(topic);
    }


    /**
     * Serializes object tree into JSON. skips over fields starting with underscore
     */
    public static io.datawire.quark.runtime.JSONObject toJSON(Object obj, quark.reflect.Class cls) {
        io.datawire.quark.runtime.JSONObject result = new io.datawire.quark.runtime.JSONObject();
        if ((obj)==(null) || ((Object)(obj) != null && ((Object) (obj)).equals(null))) {
            (result).setNull();
            return result;
        }
        if (((cls)==(null) || ((Object)(cls) != null && ((Object) (cls)).equals(null))) || ((cls).isAbstract())) {
            cls = quark.reflect.Class.get(io.datawire.quark.runtime.Builtins._getClass(obj));
        }
        Integer idx = 0;
        if (((cls).name)==("quark.String") || ((Object)((cls).name) != null && ((Object) ((cls).name)).equals("quark.String"))) {
            (result).setString((String) (obj));
            return result;
        }
        if (((((((cls).name)==("quark.byte") || ((Object)((cls).name) != null && ((Object) ((cls).name)).equals("quark.byte"))) || (((cls).name)==("quark.short") || ((Object)((cls).name) != null && ((Object) ((cls).name)).equals("quark.short")))) || (((cls).name)==("quark.int") || ((Object)((cls).name) != null && ((Object) ((cls).name)).equals("quark.int")))) || (((cls).name)==("quark.long") || ((Object)((cls).name) != null && ((Object) ((cls).name)).equals("quark.long")))) || (((cls).name)==("quark.float") || ((Object)((cls).name) != null && ((Object) ((cls).name)).equals("quark.float")))) {
            (result).setNumber(obj);
            return result;
        }
        if (((cls).name)==("quark.List") || ((Object)((cls).name) != null && ((Object) ((cls).name)).equals("quark.List"))) {
            (result).setList();
            java.util.ArrayList<Object> qlist = (java.util.ArrayList<Object>) (obj);
            while ((idx) < ((qlist).size())) {
                (result).setListItem(idx, Functions.toJSON((qlist).get(idx), null));
                idx = (idx) + (1);
            }
            return result;
        }
        if (((cls).name)==("quark.Map") || ((Object)((cls).name) != null && ((Object) ((cls).name)).equals("quark.Map"))) {
            (result).setObject();
            java.util.HashMap<Object,Object> map = (java.util.HashMap<Object,Object>) (obj);
            java.util.ArrayList<Object> keys = new java.util.ArrayList((map).keySet());
            Object key;
            String strKey;
            java.util.HashMap<String,Object> keyMap = io.datawire.quark.runtime.Builtins.map(new Object[]{});
            java.util.ArrayList<String> strKeys = new java.util.ArrayList(java.util.Arrays.asList(new Object[]{}));
            while ((idx) < ((keys).size())) {
                key = (keys).get(idx);
                strKey = ("" + (key));
                strKey = (Functions.toJSON(key, ((cls).getParameters()).get(0))).toString();
                (keyMap).put((strKey), (key));
                (strKeys).add(strKey);
                idx = (idx) + (1);
            }
            java.util.Collections.sort(strKeys, io.datawire.quark.runtime.Builtins.COMPARATOR);
            idx = 0;
            io.datawire.quark.runtime.JSONObject hash = (io.datawire.quark.runtime.JSONObject) (null);
            Integer hashIdx = 0;
            while ((idx) < ((strKeys).size())) {
                strKey = (strKeys).get(idx);
                key = (keyMap).get(strKey);
                Object value = (map).get(key);
                if (((quark.reflect.Class.get(io.datawire.quark.runtime.Builtins._getClass(key))).name)==("quark.String") || ((Object)((quark.reflect.Class.get(io.datawire.quark.runtime.Builtins._getClass(key))).name) != null && ((Object) ((quark.reflect.Class.get(io.datawire.quark.runtime.Builtins._getClass(key))).name)).equals("quark.String"))) {
                    (result).setObjectItem(((String) (key)), (Functions.toJSON(value, ((cls).getParameters()).get(1))));
                } else {
                    if ((hash)==(null) || ((Object)(hash) != null && ((Object) (hash)).equals(null))) {
                        hash = (new io.datawire.quark.runtime.JSONObject()).setList();
                        (result).setObjectItem(("$map"), (hash));
                    }
                    (hash).setListItem(hashIdx, Functions.toJSON(key, ((cls).getParameters()).get(0)));
                    (hash).setListItem((hashIdx) + (1), Functions.toJSON(value, ((cls).getParameters()).get(1)));
                    hashIdx = (hashIdx) + (2);
                }
                idx = (idx) + (1);
            }
            return result;
        }
        (result).setObjectItem(("$class"), ((new io.datawire.quark.runtime.JSONObject()).setString((cls).id)));
        java.util.ArrayList<quark.reflect.Field> fields = (cls).getFields();
        while ((idx) < ((fields).size())) {
            String fieldName = ((fields).get(idx)).name;
            if (!(Boolean.valueOf((fieldName).startsWith("_")))) {
                (result).setObjectItem((fieldName), (Functions.toJSON(((io.datawire.quark.runtime.QObject) (obj))._getField(fieldName), ((fields).get(idx)).getType())));
            }
            idx = (idx) + (1);
        }
        return result;
    }


    /**
     * deserialize json into provided result object. Skip over fields starting with underscore
     */
    public static Object fromJSON(quark.reflect.Class cls, Object result, io.datawire.quark.runtime.JSONObject json) {
        if ((((json)==(null) || ((Object)(json) != null && ((Object) (json)).equals(null))) || ((json).isNull())) || ((json).isUndefined())) {
            return null;
        }
        Integer idx = 0;
        Boolean genericNumber = false;
        if (((cls)==(null) || ((Object)(cls) != null && ((Object) (cls)).equals(null))) || ((cls).isAbstract())) {
            String type = (json).getType();
            if ((type)==("boolean") || ((Object)(type) != null && ((Object) (type)).equals("boolean"))) {
                cls = quark.reflect.Class.BOOL;
            }
            if ((type)==("number") || ((Object)(type) != null && ((Object) (type)).equals("number"))) {
                cls = quark.reflect.Class.FLOAT;
                genericNumber = true;
            }
            if ((type)==("string") || ((Object)(type) != null && ((Object) (type)).equals("string"))) {
                cls = quark.reflect.Class.STRING;
            }
            if ((type)==("list") || ((Object)(type) != null && ((Object) (type)).equals("list"))) {
                if ((result)==(null) || ((Object)(result) != null && ((Object) (result)).equals(null))) {
                    result = new java.util.ArrayList(java.util.Arrays.asList(new Object[]{}));
                }
                cls = quark.reflect.Class.get(io.datawire.quark.runtime.Builtins._getClass(result));
            }
            if ((type)==("object") || ((Object)(type) != null && ((Object) (type)).equals("object"))) {
                String klazz = ((json).getObjectItem("$class")).getString();
                if (!((klazz)==(null) || ((Object)(klazz) != null && ((Object) (klazz)).equals(null)))) {
                    cls = quark.reflect.Class.get(klazz);
                } else {
                    if ((result)==(null) || ((Object)(result) != null && ((Object) (result)).equals(null))) {
                        result = io.datawire.quark.runtime.Builtins.map(new Object[]{});
                    }
                    cls = quark.reflect.Class.get(io.datawire.quark.runtime.Builtins._getClass(result));
                }
            }
        }
        if ((result)==(null) || ((Object)(result) != null && ((Object) (result)).equals(null))) {
            if (((cls).name)==("quark.String") || ((Object)((cls).name) != null && ((Object) ((cls).name)).equals("quark.String"))) {
                String s = (json).getString();
                return s;
            }
            if (((cls).name)==("quark.float") || ((Object)((cls).name) != null && ((Object) ((cls).name)).equals("quark.float"))) {
                Double flt = (json).getNumber();
                if (genericNumber) {
                    if ((Math.round(flt))==(flt) || ((Object)(Math.round(flt)) != null && ((Object) (Math.round(flt))).equals(flt))) {
                        Long l2 = Math.round((json).getNumber());
                        return l2;
                    }
                }
                return flt;
            }
            if (((cls).name)==("quark.int") || ((Object)((cls).name) != null && ((Object) ((cls).name)).equals("quark.int"))) {
                Integer i = ((int) Math.round((json).getNumber()));
                return i;
            }
            if (((cls).name)==("quark.long") || ((Object)((cls).name) != null && ((Object) ((cls).name)).equals("quark.long"))) {
                Long l = Math.round((json).getNumber());
                return l;
            }
            if (((cls).name)==("quark.bool") || ((Object)((cls).name) != null && ((Object) ((cls).name)).equals("quark.bool"))) {
                Boolean b = (json).getBool();
                return b;
            }
            result = (cls).construct(new java.util.ArrayList(java.util.Arrays.asList(new Object[]{})));
        }
        if (((cls).name)==("quark.List") || ((Object)((cls).name) != null && ((Object) ((cls).name)).equals("quark.List"))) {
            java.util.ArrayList<Object> qlist = (java.util.ArrayList<Object>) (result);
            while ((idx) < ((json).size())) {
                (qlist).add(Functions.fromJSON(((cls).getParameters()).get(0), null, (json).getListItem(idx)));
                idx = (idx) + (1);
            }
            return qlist;
        }
        if (((cls).name)==("quark.Map") || ((Object)((cls).name) != null && ((Object) ((cls).name)).equals("quark.Map"))) {
            java.util.HashMap<Object,Object> map = (java.util.HashMap<Object,Object>) (result);
            java.util.ArrayList<String> keys = (json).keys();
            while ((idx) < ((keys).size())) {
                String key = (keys).get(idx);
                io.datawire.quark.runtime.JSONObject value = (json).getObjectItem(key);
                if (!((key)==("$map") || ((Object)(key) != null && ((Object) (key)).equals("$map")))) {
                    (map).put((key), (Functions.fromJSON(((cls).getParameters()).get(1), null, value)));
                } else {
                    Integer hashIdx = 0;
                    while ((hashIdx) < ((value).size())) {
                        Object hkey = Functions.fromJSON(((cls).getParameters()).get(0), null, (value).getListItem(hashIdx));
                        Object hvalue = Functions.fromJSON(((cls).getParameters()).get(1), null, (value).getListItem((hashIdx) + (1)));
                        (map).put((hkey), (hvalue));
                        hashIdx = (hashIdx) + (2);
                    }
                }
                idx = (idx) + (1);
            }
        }
        java.util.ArrayList<quark.reflect.Field> fields = (cls).getFields();
        while ((idx) < ((fields).size())) {
            quark.reflect.Field f = (fields).get(idx);
            idx = (idx) + (1);
            if (Boolean.valueOf(((f).name).startsWith("_"))) {
                continue;
            }
            if ((((json).getObjectItem((f).name)).isDefined()) && (!(((json).getObjectItem((f).name)).isNull()))) {
                ((io.datawire.quark.runtime.QObject) (result))._setField((f).name, Functions.fromJSON((f).getType(), null, (json).getObjectItem((f).name)));
            }
        }
        return result;
    }
}
