/* Quark 1.0.452 run at 2016-10-24 14:33:24.783025 */
package mdk_tracing.protocol;

public class TracingClient implements mdk_protocol.WSClientSubscriber, io.datawire.quark.runtime.QObject {
    public static quark.reflect.Class mdk_tracing_protocol_TracingClient_ref = datawire_mdk_md.Root.mdk_tracing_protocol_TracingClient_md;
    public mdk_tracing.Tracer _tracer;
    public Boolean _started = false;
    public io.datawire.quark.runtime.Lock _mutex = new io.datawire.quark.runtime.Lock();
    public quark.UnaryCallable _handler = null;
    public mdk_runtime.actors.MessageDispatcher _dispatcher;
    public Long _syncRequestPeriod = 5000L;
    public Integer _syncInFlightMax = 50;
    public java.util.ArrayList<LogEvent> _buffered = new java.util.ArrayList(java.util.Arrays.asList(new Object[]{}));
    public java.util.ArrayList<LogEvent> _inFlight = new java.util.ArrayList(java.util.Arrays.asList(new Object[]{}));
    public Long _logged = 0L;
    public Long _sent = 0L;
    public Long _failedSends = 0L;
    public Long _recorded = 0L;
    public Long _lastSyncTime = 0L;
    public mdk_protocol.WSClient _wsclient;
    public mdk_runtime.actors.Actor _sock = null;
    public io.datawire.quark.runtime.Logger _myLog = quark.Functions._getLogger("TracingClient");
    public TracingClient(mdk_tracing.Tracer tracer, mdk_protocol.WSClient wsclient) {
        this._tracer = tracer;
        this._wsclient = wsclient;
        (wsclient).subscribe(this);
    }
    public void _debug(String message) {
        String s = (((("[") + (Integer.toString((this._buffered).size()))) + (" buf, ")) + (Integer.toString((this._inFlight).size()))) + (" inf] ");
        (this._myLog).debug((s) + (message));
    }
    /**
     * Attach a subscriber that will receive results of queries.
     */
    public void subscribe(quark.UnaryCallable handler) {
        (this._mutex).acquire();
        this._handler = handler;
        (this._mutex).release();
    }
    public void onStart(mdk_runtime.actors.MessageDispatcher dispatcher) {
        (this)._dispatcher = dispatcher;
    }
    public void onStop() {}
    public void onMessage(mdk_runtime.actors.Actor origin, Object message) {
        mdk_protocol.Functions._subscriberDispatch(this, message);
    }
    public void onWSConnected(mdk_runtime.actors.Actor websock) {
        (this._mutex).acquire();
        (this)._sock = websock;
        while (((this._inFlight).size()) > (0)) {
            LogEvent evt = (this._inFlight).remove((int)(((this._inFlight).size()) - (1)));
            (this._buffered).add((0), (evt));
            this._failedSends = (this._failedSends) + (new Long(1));
            this._debug(("no ack for #") + (Long.toString((evt).sequence)));
        }
        this._debug(("Starting up! with connection ") + (("" + ((this)._sock))));
        if (!((this._handler)==(null) || ((Object)(this._handler) != null && ((Object) (this._handler)).equals(null)))) {
            ((this)._dispatcher).tell(this, (new Subscribe()).encode(), (this)._sock);
        }
        (this._mutex).release();
    }
    public void onPump() {
        (this._mutex).acquire();
        while (((this._buffered).size()) > (0)) {
            String debugSuffix = "";
            LogEvent evt = (this._buffered).remove((int)(0));
            (this._inFlight).add(evt);
            if ((((evt).timestamp) > ((this._lastSyncTime) + (this._syncRequestPeriod))) || (((this._inFlight).size())==(this._syncInFlightMax) || ((Object)((this._inFlight).size()) != null && ((Object) ((this._inFlight).size())).equals(this._syncInFlightMax)))) {
                (evt).sync = 1;
                this._lastSyncTime = (evt).timestamp;
                debugSuffix = " with sync set";
            }
            ((this)._dispatcher).tell(this, (evt).encode(), (this)._sock);
            (evt).sync = 0;
            this._sent = (this._sent) + (new Long(1));
            this._debug((((("sent #") + (Long.toString((evt).sequence))) + (debugSuffix)) + (" to ")) + (("" + ((this)._sock))));
        }
        (this._mutex).release();
    }
    public void onMessageFromServer(Object message) {
        String type = (quark.reflect.Class.get(io.datawire.quark.runtime.Builtins._getClass(message))).id;
        if ((type)==("mdk_tracing.protocol.LogEvent") || ((Object)(type) != null && ((Object) (type)).equals("mdk_tracing.protocol.LogEvent"))) {
            LogEvent event = (LogEvent) (message);
            this.onLogEvent(event);
            return;
        }
        if ((type)==("mdk_tracing.protocol.LogAck") || ((Object)(type) != null && ((Object) (type)).equals("mdk_tracing.protocol.LogAck"))) {
            LogAck ack = (LogAck) (message);
            (this).onLogAck(ack);
            return;
        }
    }
    public void onLogEvent(LogEvent evt) {
        (this._mutex).acquire();
        if (!((this._handler)==(null) || ((Object)(this._handler) != null && ((Object) (this._handler)).equals(null)))) {
            (this._handler).call(evt);
        }
        (this._mutex).release();
    }
    public void onLogAck(LogAck ack) {
        (this._mutex).acquire();
        while (((this._inFlight).size()) > (0)) {
            if ((((this._inFlight).get(0)).sequence) <= ((ack).sequence)) {
                LogEvent evt = (this._inFlight).remove((int)(0));
                this._recorded = (this._recorded) + (new Long(1));
                this._debug(((("ack #") + (Long.toString((ack).sequence))) + (", discarding #")) + (Long.toString((evt).sequence)));
            } else {
                break;
            }
        }
        (this._mutex).release();
    }
    /**
     * Queue a log message for delivery to the server.
     */
    public void log(LogEvent evt) {
        (this._mutex).acquire();
        (evt).sequence = this._logged;
        (evt).sync = 0;
        this._logged = (this._logged) + (new Long(1));
        (this._buffered).add(evt);
        this._debug(("logged #") + (Long.toString((evt).sequence)));
        (this._mutex).release();
    }
    public String _getClass() {
        return "mdk_tracing.protocol.TracingClient";
    }
    public Object _getField(String name) {
        if ((name)==("_tracer") || ((Object)(name) != null && ((Object) (name)).equals("_tracer"))) {
            return (this)._tracer;
        }
        if ((name)==("_started") || ((Object)(name) != null && ((Object) (name)).equals("_started"))) {
            return (this)._started;
        }
        if ((name)==("_mutex") || ((Object)(name) != null && ((Object) (name)).equals("_mutex"))) {
            return (this)._mutex;
        }
        if ((name)==("_handler") || ((Object)(name) != null && ((Object) (name)).equals("_handler"))) {
            return (this)._handler;
        }
        if ((name)==("_dispatcher") || ((Object)(name) != null && ((Object) (name)).equals("_dispatcher"))) {
            return (this)._dispatcher;
        }
        if ((name)==("_syncRequestPeriod") || ((Object)(name) != null && ((Object) (name)).equals("_syncRequestPeriod"))) {
            return (this)._syncRequestPeriod;
        }
        if ((name)==("_syncInFlightMax") || ((Object)(name) != null && ((Object) (name)).equals("_syncInFlightMax"))) {
            return (this)._syncInFlightMax;
        }
        if ((name)==("_buffered") || ((Object)(name) != null && ((Object) (name)).equals("_buffered"))) {
            return (this)._buffered;
        }
        if ((name)==("_inFlight") || ((Object)(name) != null && ((Object) (name)).equals("_inFlight"))) {
            return (this)._inFlight;
        }
        if ((name)==("_logged") || ((Object)(name) != null && ((Object) (name)).equals("_logged"))) {
            return (this)._logged;
        }
        if ((name)==("_sent") || ((Object)(name) != null && ((Object) (name)).equals("_sent"))) {
            return (this)._sent;
        }
        if ((name)==("_failedSends") || ((Object)(name) != null && ((Object) (name)).equals("_failedSends"))) {
            return (this)._failedSends;
        }
        if ((name)==("_recorded") || ((Object)(name) != null && ((Object) (name)).equals("_recorded"))) {
            return (this)._recorded;
        }
        if ((name)==("_lastSyncTime") || ((Object)(name) != null && ((Object) (name)).equals("_lastSyncTime"))) {
            return (this)._lastSyncTime;
        }
        if ((name)==("_wsclient") || ((Object)(name) != null && ((Object) (name)).equals("_wsclient"))) {
            return (this)._wsclient;
        }
        if ((name)==("_sock") || ((Object)(name) != null && ((Object) (name)).equals("_sock"))) {
            return (this)._sock;
        }
        if ((name)==("_myLog") || ((Object)(name) != null && ((Object) (name)).equals("_myLog"))) {
            return (this)._myLog;
        }
        return null;
    }
    public void _setField(String name, Object value) {
        if ((name)==("_tracer") || ((Object)(name) != null && ((Object) (name)).equals("_tracer"))) {
            (this)._tracer = (mdk_tracing.Tracer) (value);
        }
        if ((name)==("_started") || ((Object)(name) != null && ((Object) (name)).equals("_started"))) {
            (this)._started = (Boolean) (value);
        }
        if ((name)==("_mutex") || ((Object)(name) != null && ((Object) (name)).equals("_mutex"))) {
            (this)._mutex = (io.datawire.quark.runtime.Lock) (value);
        }
        if ((name)==("_handler") || ((Object)(name) != null && ((Object) (name)).equals("_handler"))) {
            (this)._handler = (quark.UnaryCallable) (value);
        }
        if ((name)==("_dispatcher") || ((Object)(name) != null && ((Object) (name)).equals("_dispatcher"))) {
            (this)._dispatcher = (mdk_runtime.actors.MessageDispatcher) (value);
        }
        if ((name)==("_syncRequestPeriod") || ((Object)(name) != null && ((Object) (name)).equals("_syncRequestPeriod"))) {
            (this)._syncRequestPeriod = (Long) (value);
        }
        if ((name)==("_syncInFlightMax") || ((Object)(name) != null && ((Object) (name)).equals("_syncInFlightMax"))) {
            (this)._syncInFlightMax = (Integer) (value);
        }
        if ((name)==("_buffered") || ((Object)(name) != null && ((Object) (name)).equals("_buffered"))) {
            (this)._buffered = (java.util.ArrayList<LogEvent>) (value);
        }
        if ((name)==("_inFlight") || ((Object)(name) != null && ((Object) (name)).equals("_inFlight"))) {
            (this)._inFlight = (java.util.ArrayList<LogEvent>) (value);
        }
        if ((name)==("_logged") || ((Object)(name) != null && ((Object) (name)).equals("_logged"))) {
            (this)._logged = (Long) (value);
        }
        if ((name)==("_sent") || ((Object)(name) != null && ((Object) (name)).equals("_sent"))) {
            (this)._sent = (Long) (value);
        }
        if ((name)==("_failedSends") || ((Object)(name) != null && ((Object) (name)).equals("_failedSends"))) {
            (this)._failedSends = (Long) (value);
        }
        if ((name)==("_recorded") || ((Object)(name) != null && ((Object) (name)).equals("_recorded"))) {
            (this)._recorded = (Long) (value);
        }
        if ((name)==("_lastSyncTime") || ((Object)(name) != null && ((Object) (name)).equals("_lastSyncTime"))) {
            (this)._lastSyncTime = (Long) (value);
        }
        if ((name)==("_wsclient") || ((Object)(name) != null && ((Object) (name)).equals("_wsclient"))) {
            (this)._wsclient = (mdk_protocol.WSClient) (value);
        }
        if ((name)==("_sock") || ((Object)(name) != null && ((Object) (name)).equals("_sock"))) {
            (this)._sock = (mdk_runtime.actors.Actor) (value);
        }
        if ((name)==("_myLog") || ((Object)(name) != null && ((Object) (name)).equals("_myLog"))) {
            (this)._myLog = (io.datawire.quark.runtime.Logger) (value);
        }
    }
}
