/* Quark 1.0.452 run at 2016-10-24 14:33:24.783025 */
package mdk_runtime.actors;

/**
 * Manage a group of related Actors.
 *
 * Each Actor should only be started and used by one MessageDispatcher.
 *
 * Reduce accidental re-entrancy by making sure messages are run asynchronously.
 *
 */
public class MessageDispatcher implements io.datawire.quark.runtime.QObject {
    public static quark.reflect.Class quark_List_mdk_runtime_actors__QueuedMessage__ref = datawire_mdk_md.Root.quark_List_mdk_runtime_actors__QueuedMessage__md;
    public static quark.reflect.Class mdk_runtime_actors_MessageDispatcher_ref = datawire_mdk_md.Root.mdk_runtime_actors_MessageDispatcher_md;
    public io.datawire.quark.runtime.Logger logger = quark.Functions._getLogger("actors");
    public java.util.ArrayList<_QueuedMessage> _queued = new java.util.ArrayList(java.util.Arrays.asList(new Object[]{}));
    public Boolean _delivering = false;
    public io.datawire.quark.runtime.Lock _lock = new io.datawire.quark.runtime.Lock();
    public MessageDispatcher() {}
    /**
     * Queue a message from origin to destination, and trigger delivery if necessary.
     */
    public void tell(Actor origin, Object message, Actor destination) {
        _InFlightMessage inFlight = new _InFlightMessage(origin, message, destination);
        (this)._queue(inFlight);
    }
    /**
     * Start an Actor.
     */
    public void startActor(Actor actor) {
        (this)._queue(new _StartStopActor(actor, this, true));
    }
    /**
     * Stop an Actor.
     */
    public void stopActor(Actor actor) {
        (this)._queue(new _StartStopActor(actor, this, false));
    }
    public Boolean _callQueuedMessage(Object ignore, _QueuedMessage message) {
        (message).deliver();
        return true;
    }
    /**
     * Queue a message for delivery.
     */
    public void _queue(_QueuedMessage inFlight) {
        (this.logger).debug(("Queued ") + (("" + (inFlight))));
        ((this)._lock).acquire();
        ((this)._queued).add(inFlight);
        if ((this)._delivering) {
            ((this)._lock).release();
            return;
        }
        (this)._delivering = true;
        while ((((this)._queued).size()) > (0)) {
            java.util.ArrayList<_QueuedMessage> toDeliver = (this)._queued;
            (this)._queued = new java.util.ArrayList(java.util.Arrays.asList(new Object[]{}));
            ((this)._lock).release();
            Integer idx = 0;
            while ((idx) < ((toDeliver).size())) {
                (this.logger).debug(("Delivering ") + (("" + ((toDeliver).get(idx)))));
                quark.UnaryCallable deliver = new quark._BoundMethod(this, "_callQueuedMessage", new java.util.ArrayList(java.util.Arrays.asList(new Object[]{(toDeliver).get(idx)})));
                (quark.concurrent.Context.runtime()).callSafely(deliver, false);
                idx = (idx) + (1);
            }
            ((this)._lock).acquire();
        }
        (this)._delivering = false;
        ((this)._lock).release();
    }
    public String _getClass() {
        return "mdk_runtime.actors.MessageDispatcher";
    }
    public Object _getField(String name) {
        if ((name)==("logger") || ((Object)(name) != null && ((Object) (name)).equals("logger"))) {
            return (this).logger;
        }
        if ((name)==("_queued") || ((Object)(name) != null && ((Object) (name)).equals("_queued"))) {
            return (this)._queued;
        }
        if ((name)==("_delivering") || ((Object)(name) != null && ((Object) (name)).equals("_delivering"))) {
            return (this)._delivering;
        }
        if ((name)==("_lock") || ((Object)(name) != null && ((Object) (name)).equals("_lock"))) {
            return (this)._lock;
        }
        return null;
    }
    public void _setField(String name, Object value) {
        if ((name)==("logger") || ((Object)(name) != null && ((Object) (name)).equals("logger"))) {
            (this).logger = (io.datawire.quark.runtime.Logger) (value);
        }
        if ((name)==("_queued") || ((Object)(name) != null && ((Object) (name)).equals("_queued"))) {
            (this)._queued = (java.util.ArrayList<_QueuedMessage>) (value);
        }
        if ((name)==("_delivering") || ((Object)(name) != null && ((Object) (name)).equals("_delivering"))) {
            (this)._delivering = (Boolean) (value);
        }
        if ((name)==("_lock") || ((Object)(name) != null && ((Object) (name)).equals("_lock"))) {
            (this)._lock = (io.datawire.quark.runtime.Lock) (value);
        }
    }
}
