/* Quark 1.0.452 run at 2016-10-24 14:33:24.783025 */
package mdk_runtime;

/**
 * WSActor that uses current Quark runtime as temporary expedient.
 *
 * State can be 'ERROR', 'CONNECTING', 'CONNECTED', 'DISCONNECTING',
 * 'DISCONNECTED'.
 *
 */
public class QuarkRuntimeWSActor implements WSActor, quark.WSHandler, io.datawire.quark.runtime.QObject {
    public static quark.reflect.Class mdk_runtime_QuarkRuntimeWSActor_ref = datawire_mdk_md.Root.mdk_runtime_QuarkRuntimeWSActor_md;
    public io.datawire.quark.runtime.Logger logger = quark.Functions._getLogger("protocol");
    public quark.WebSocket socket;
    public mdk_runtime.promise.PromiseResolver factory;
    public mdk_runtime.actors.Actor originator;
    public String url;
    public String shortURL;
    public mdk_runtime.actors.MessageDispatcher dispatcher;
    public String state = "CONNECTING";
    public QuarkRuntimeWSActor(String url, mdk_runtime.actors.Actor originator, mdk_runtime.promise.PromiseResolver factory) {
        (this).url = url;
        (this).originator = originator;
        (this).factory = factory;
        java.util.ArrayList<String> pieces = new java.util.ArrayList<String>(java.util.Arrays.asList((url).split(java.util.regex.Pattern.quote("?"), -1)));
        (this).shortURL = (pieces).get(0);
        if (((pieces).size()) > (1)) {
            (this).shortURL = (((this).shortURL) + ("?")) + (((pieces).get(1)).substring((0), (8)));
        }
    }
    public void logTS(String message) {
        if (true) {
            return;
        }
        Long now = (quark.concurrent.Context.runtime()).now();
        Integer tenths = io.datawire.quark.runtime.Builtins.modulo((~((~((int) ((Long) (now)).intValue())) / (100))), (100000));
        if ((tenths) < (0)) {
            tenths = (tenths) + (100000);
        }
        Double seconds = (Double.valueOf(tenths)) / (10.0);
        (this.logger).debug(((Double.toString(seconds)) + (" ")) + (message));
    }
    public void logPrologue(String what) {
        String disMessage = "";
        if (((this).dispatcher)==(null) || ((Object)((this).dispatcher) != null && ((Object) ((this).dispatcher)).equals(null))) {
            disMessage = ", no dispatcher";
        }
        this.logTS(((((((((((what) + (", current state ")) + ((this).state)) + (", originator ")) + (("" + ((this).originator)))) + (", I am ")) + (("" + (this)))) + (" [")) + ((this).shortURL)) + ("]")) + (disMessage));
    }
    public void onStart(mdk_runtime.actors.MessageDispatcher dispatcher) {
        this.logPrologue("ws onStart");
        (this).dispatcher = dispatcher;
        (quark.concurrent.Context.runtime()).open((this).url, this);
    }
    public void onMessage(mdk_runtime.actors.Actor origin, Object message) {
        this.logPrologue("ws onMessage (actor message)");
        this.logTS(("   message is from ") + (("" + (origin))));
        if ((((quark.reflect.Class.get(io.datawire.quark.runtime.Builtins._getClass(message))).id)==("quark.String") || ((Object)((quark.reflect.Class.get(io.datawire.quark.runtime.Builtins._getClass(message))).id) != null && ((Object) ((quark.reflect.Class.get(io.datawire.quark.runtime.Builtins._getClass(message))).id)).equals("quark.String"))) && (((this).state)==("CONNECTED") || ((Object)((this).state) != null && ((Object) ((this).state)).equals("CONNECTED")))) {
            this.logTS(("   send-ish, message is: ") + (("" + (message))));
            Functions.log_to_file(("sending: ") + ((String) (message)));
            ((this).socket).send((String) (message));
            return;
        }
        if ((((quark.reflect.Class.get(io.datawire.quark.runtime.Builtins._getClass(message))).id)==("mdk_runtime.WSClose") || ((Object)((quark.reflect.Class.get(io.datawire.quark.runtime.Builtins._getClass(message))).id) != null && ((Object) ((quark.reflect.Class.get(io.datawire.quark.runtime.Builtins._getClass(message))).id)).equals("mdk_runtime.WSClose"))) && (((this).state)==("CONNECTED") || ((Object)((this).state) != null && ((Object) ((this).state)).equals("CONNECTED")))) {
            this.logTS("   close-ish, switching to DISCONNECTING state");
            (this).state = "DISCONNECTING";
            ((this).socket).close();
            return;
        }
        (this.logger).warn(((("ws onMessage got unhandled message: ") + ((quark.reflect.Class.get(io.datawire.quark.runtime.Builtins._getClass(message))).id)) + (" in state ")) + ((this).state));
    }
    public void onWSConnected(quark.WebSocket socket) {
        this.logPrologue("onWSConnected");
        if (((this).state)==("ERROR") || ((Object)((this).state) != null && ((Object) ((this).state)).equals("ERROR"))) {
            this.logTS("Connection event after error event!");
            return;
        }
        (this).state = "CONNECTED";
        (this).socket = socket;
        ((this).factory).resolve(this);
    }
    public void onWSError(quark.WebSocket socket, quark.WSError error) {
        this.logPrologue("onWSError");
        this.logTS(("onWSError, reason is: ") + ((error).toString()));
        if (((this).state)==("CONNECTING") || ((Object)((this).state) != null && ((Object) ((this).state)).equals("CONNECTING"))) {
            (this.logger).error(("Error connecting to WebSocket: ") + ((error).toString()));
            (this).state = "ERROR";
            ((this).factory).reject(new WSConnectError((error).toString()));
            return;
        }
        (this.logger).error(("WebSocket error: ") + ((error).toString()));
    }
    public void onWSMessage(quark.WebSocket socket, String message) {
        this.logPrologue("onWSMessage");
        this.logTS(("onWSMessage, message is: ") + (message));
        Functions.log_to_file(("received: ") + (message));
        ((this).dispatcher).tell(this, new WSMessage(message), (this).originator);
    }
    public void onWSFinal(quark.WebSocket socket) {
        this.logPrologue("onWSFinal");
        if ((((this).state)==("DISCONNECTING") || ((Object)((this).state) != null && ((Object) ((this).state)).equals("DISCONNECTING"))) || (((this).state)==("CONNECTED") || ((Object)((this).state) != null && ((Object) ((this).state)).equals("CONNECTED")))) {
            (this).state = "DISCONNECTED";
            (this).socket = (quark.WebSocket) (null);
            ((this).dispatcher).tell(this, new WSClosed(), (this).originator);
        }
    }
    public String _getClass() {
        return "mdk_runtime.QuarkRuntimeWSActor";
    }
    public Object _getField(String name) {
        if ((name)==("logger") || ((Object)(name) != null && ((Object) (name)).equals("logger"))) {
            return (this).logger;
        }
        if ((name)==("socket") || ((Object)(name) != null && ((Object) (name)).equals("socket"))) {
            return (this).socket;
        }
        if ((name)==("factory") || ((Object)(name) != null && ((Object) (name)).equals("factory"))) {
            return (this).factory;
        }
        if ((name)==("originator") || ((Object)(name) != null && ((Object) (name)).equals("originator"))) {
            return (this).originator;
        }
        if ((name)==("url") || ((Object)(name) != null && ((Object) (name)).equals("url"))) {
            return (this).url;
        }
        if ((name)==("shortURL") || ((Object)(name) != null && ((Object) (name)).equals("shortURL"))) {
            return (this).shortURL;
        }
        if ((name)==("dispatcher") || ((Object)(name) != null && ((Object) (name)).equals("dispatcher"))) {
            return (this).dispatcher;
        }
        if ((name)==("state") || ((Object)(name) != null && ((Object) (name)).equals("state"))) {
            return (this).state;
        }
        return null;
    }
    public void _setField(String name, Object value) {
        if ((name)==("logger") || ((Object)(name) != null && ((Object) (name)).equals("logger"))) {
            (this).logger = (io.datawire.quark.runtime.Logger) (value);
        }
        if ((name)==("socket") || ((Object)(name) != null && ((Object) (name)).equals("socket"))) {
            (this).socket = (quark.WebSocket) (value);
        }
        if ((name)==("factory") || ((Object)(name) != null && ((Object) (name)).equals("factory"))) {
            (this).factory = (mdk_runtime.promise.PromiseResolver) (value);
        }
        if ((name)==("originator") || ((Object)(name) != null && ((Object) (name)).equals("originator"))) {
            (this).originator = (mdk_runtime.actors.Actor) (value);
        }
        if ((name)==("url") || ((Object)(name) != null && ((Object) (name)).equals("url"))) {
            (this).url = (String) (value);
        }
        if ((name)==("shortURL") || ((Object)(name) != null && ((Object) (name)).equals("shortURL"))) {
            (this).shortURL = (String) (value);
        }
        if ((name)==("dispatcher") || ((Object)(name) != null && ((Object) (name)).equals("dispatcher"))) {
            (this).dispatcher = (mdk_runtime.actors.MessageDispatcher) (value);
        }
        if ((name)==("state") || ((Object)(name) != null && ((Object) (name)).equals("state"))) {
            (this).state = (String) (value);
        }
    }
    /**
     * The Actor should begin shutting down.
     */
    public void onStop() {}
    /**
     * Called when the WebSocket is first created.
     */
    public void onWSInit(quark.WebSocket socket) {}
    /**
     * Called when the WebSocket receives a binary message.
     */
    public void onWSBinary(quark.WebSocket socket, io.datawire.quark.runtime.Buffer message) {}
    /**
     * Called when the WebSocket disconnects cleanly.
     */
    public void onWSClosed(quark.WebSocket socket) {}
}
