/* Quark 1.0.452 run at 2016-10-24 14:33:24.783025 */
package mdk_runtime;

/**
 * Runtime environment for a particular MDK instance.
 *
 * Required registered services:
 * - 'time': A provider of mdk_runtime.Time;
 * - 'schedule': Implements the mdk_runtime.ScheduleActor actor protocol.
 * - 'websockets': A provider of mdk_runtime.WebSockets.
 *
 */
public class MDKRuntime implements io.datawire.quark.runtime.QObject {
    public static quark.reflect.Class mdk_runtime_MDKRuntime_ref = datawire_mdk_md.Root.mdk_runtime_MDKRuntime_md;
    public Dependencies dependencies = new Dependencies();
    public mdk_runtime.actors.MessageDispatcher dispatcher = new mdk_runtime.actors.MessageDispatcher();
    public MDKRuntime() {}
    /**
     * Return Time service.
     */
    public Time getTimeService() {
        return (Time) (((this).dependencies).getService("time"));
    }
    /**
     * Return Schedule service.
     */
    public mdk_runtime.actors.Actor getScheduleService() {
        return (mdk_runtime.actors.Actor) (((this).dependencies).getService("schedule"));
    }
    /**
     * Return WebSockets service.
     */
    public WebSockets getWebSocketsService() {
        return (WebSockets) (((this).dependencies).getService("websockets"));
    }
    /**
     * Return File service.
     */
    public mdk_runtime.files.FileActor getFileService() {
        return (mdk_runtime.files.FileActor) (((this).dependencies).getService("files"));
    }
    /**
     * Return EnvironmentVariables service.
     */
    public EnvironmentVariables getEnvVarsService() {
        return (EnvironmentVariables) (((this).dependencies).getService("envvar"));
    }
    /**
     * Stop all Actors that are started by default (i.e. files, schedule).
     */
    public void stop() {
        ((this).dispatcher).stopActor(this.getFileService());
        ((this).dispatcher).stopActor((this).getScheduleService());
        ((this).dispatcher).stopActor((this).getWebSocketsService());
    }
    public String _getClass() {
        return "mdk_runtime.MDKRuntime";
    }
    public Object _getField(String name) {
        if ((name)==("dependencies") || ((Object)(name) != null && ((Object) (name)).equals("dependencies"))) {
            return (this).dependencies;
        }
        if ((name)==("dispatcher") || ((Object)(name) != null && ((Object) (name)).equals("dispatcher"))) {
            return (this).dispatcher;
        }
        return null;
    }
    public void _setField(String name, Object value) {
        if ((name)==("dependencies") || ((Object)(name) != null && ((Object) (name)).equals("dependencies"))) {
            (this).dependencies = (Dependencies) (value);
        }
        if ((name)==("dispatcher") || ((Object)(name) != null && ((Object) (name)).equals("dispatcher"))) {
            (this).dispatcher = (mdk_runtime.actors.MessageDispatcher) (value);
        }
    }
}
