/* Quark 1.0.452 run at 2016-10-24 14:33:24.783025 */
package mdk_runtime;

/**
 * WSActor implementation for testing purposes.
 */
public class FakeWSActor implements WSActor, io.datawire.quark.runtime.QObject {
    public static quark.reflect.Class mdk_runtime_FakeWSActor_ref = datawire_mdk_md.Root.mdk_runtime_FakeWSActor_md;
    public String url;
    public mdk_runtime.promise.PromiseResolver resolver;
    public Boolean resolved = false;
    public mdk_runtime.actors.MessageDispatcher dispatcher;
    public mdk_runtime.actors.Actor originator;
    public java.util.ArrayList<String> sent = new java.util.ArrayList(java.util.Arrays.asList(new Object[]{}));
    public String state = "CONNECTING";
    public Integer expectIdx = 0;
    public FakeWSActor(mdk_runtime.actors.Actor originator, mdk_runtime.promise.PromiseResolver resolver, String url) {
        (this).url = url;
        (this).originator = originator;
        (this).resolver = resolver;
    }
    public void onStart(mdk_runtime.actors.MessageDispatcher dispatcher) {
        (this).dispatcher = dispatcher;
    }
    public void onMessage(mdk_runtime.actors.Actor origin, Object message) {
        if ((((quark.reflect.Class.get(io.datawire.quark.runtime.Builtins._getClass(message))).id)==("quark.String") || ((Object)((quark.reflect.Class.get(io.datawire.quark.runtime.Builtins._getClass(message))).id) != null && ((Object) ((quark.reflect.Class.get(io.datawire.quark.runtime.Builtins._getClass(message))).id)).equals("quark.String"))) && (((this).state)==("CONNECTED") || ((Object)((this).state) != null && ((Object) ((this).state)).equals("CONNECTED")))) {
            ((this).sent).add((String) (message));
            return;
        }
        if ((((quark.reflect.Class.get(io.datawire.quark.runtime.Builtins._getClass(message))).id)==("mdk_runtime.WSClose") || ((Object)((quark.reflect.Class.get(io.datawire.quark.runtime.Builtins._getClass(message))).id) != null && ((Object) ((quark.reflect.Class.get(io.datawire.quark.runtime.Builtins._getClass(message))).id)).equals("mdk_runtime.WSClose"))) && (((this).state)==("CONNECTED") || ((Object)((this).state) != null && ((Object) ((this).state)).equals("CONNECTED")))) {
            (this).close();
            return;
        }
    }
    /**
     * Simulate the remote peer accepting the socket connect.
     *
     */
    public void accept() {
        if (this.resolved) {
            (quark.concurrent.Context.runtime()).fail("Test bug. already accepted");
        } else {
            this.resolved = true;
            (this).state = "CONNECTED";
            ((this).resolver).resolve(this);
        }
    }
    /**
     * Simulate the remote peer rejecting the socket connect.
     */
    public void reject() {
        if (this.resolved) {
            (quark.concurrent.Context.runtime()).fail("Test bug. already accepted");
        } else {
            this.resolved = true;
            ((this).resolver).reject(new WSConnectError("connection refused"));
        }
    }
    /**
     * Simulate the remote peer sending a text message to the client.
     *
     */
    public void send(String message) {
        if (!(((this).state)==("CONNECTED") || ((Object)((this).state) != null && ((Object) ((this).state)).equals("CONNECTED")))) {
            (quark.concurrent.Context.runtime()).fail("Test bug. Can't send when not connected.");
        }
        ((this).dispatcher).tell(this, new WSMessage(message), this.originator);
    }
    /**
     * Simulate the remote peer closing the socket.
     *
     */
    public void close() {
        if (((this).state)==("CONNECTED") || ((Object)((this).state) != null && ((Object) ((this).state)).equals("CONNECTED"))) {
            (this).state = "DISCONNECTED";
            ((this).dispatcher).tell(this, new WSClosed(), this.originator);
        } else {
            (quark.concurrent.Context.runtime()).fail("Test bug. Can't close already closed socket.");
        }
    }
    /**
     * Check that a message has been sent via this actor.
     *
     */
    public String expectTextMessage() {
        if (!(this.resolved)) {
            (quark.concurrent.Context.runtime()).fail("not connected yet");
            return "unreachable";
        }
        if ((this.expectIdx) < (((this).sent).size())) {
            String msg = ((this).sent).get(this.expectIdx);
            this.expectIdx = (this.expectIdx) + (1);
            return msg;
        }
        (quark.concurrent.Context.runtime()).fail("no remaining message found");
        return "unreachable";
    }
    public String _getClass() {
        return "mdk_runtime.FakeWSActor";
    }
    public Object _getField(String name) {
        if ((name)==("url") || ((Object)(name) != null && ((Object) (name)).equals("url"))) {
            return (this).url;
        }
        if ((name)==("resolver") || ((Object)(name) != null && ((Object) (name)).equals("resolver"))) {
            return (this).resolver;
        }
        if ((name)==("resolved") || ((Object)(name) != null && ((Object) (name)).equals("resolved"))) {
            return (this).resolved;
        }
        if ((name)==("dispatcher") || ((Object)(name) != null && ((Object) (name)).equals("dispatcher"))) {
            return (this).dispatcher;
        }
        if ((name)==("originator") || ((Object)(name) != null && ((Object) (name)).equals("originator"))) {
            return (this).originator;
        }
        if ((name)==("sent") || ((Object)(name) != null && ((Object) (name)).equals("sent"))) {
            return (this).sent;
        }
        if ((name)==("state") || ((Object)(name) != null && ((Object) (name)).equals("state"))) {
            return (this).state;
        }
        if ((name)==("expectIdx") || ((Object)(name) != null && ((Object) (name)).equals("expectIdx"))) {
            return (this).expectIdx;
        }
        return null;
    }
    public void _setField(String name, Object value) {
        if ((name)==("url") || ((Object)(name) != null && ((Object) (name)).equals("url"))) {
            (this).url = (String) (value);
        }
        if ((name)==("resolver") || ((Object)(name) != null && ((Object) (name)).equals("resolver"))) {
            (this).resolver = (mdk_runtime.promise.PromiseResolver) (value);
        }
        if ((name)==("resolved") || ((Object)(name) != null && ((Object) (name)).equals("resolved"))) {
            (this).resolved = (Boolean) (value);
        }
        if ((name)==("dispatcher") || ((Object)(name) != null && ((Object) (name)).equals("dispatcher"))) {
            (this).dispatcher = (mdk_runtime.actors.MessageDispatcher) (value);
        }
        if ((name)==("originator") || ((Object)(name) != null && ((Object) (name)).equals("originator"))) {
            (this).originator = (mdk_runtime.actors.Actor) (value);
        }
        if ((name)==("sent") || ((Object)(name) != null && ((Object) (name)).equals("sent"))) {
            (this).sent = (java.util.ArrayList<String>) (value);
        }
        if ((name)==("state") || ((Object)(name) != null && ((Object) (name)).equals("state"))) {
            (this).state = (String) (value);
        }
        if ((name)==("expectIdx") || ((Object)(name) != null && ((Object) (name)).equals("expectIdx"))) {
            (this).expectIdx = (Integer) (value);
        }
    }
    /**
     * The Actor should begin shutting down.
     */
    public void onStop() {}
}
