/* Quark 1.0.452 run at 2016-10-24 14:33:24.783025 */
package mdk_protocol;

/**
 * Common protocol machinery for web socket based protocol clients.
 */
public class WSClient implements mdk_runtime.actors.Actor, io.datawire.quark.runtime.QObject {
    public static quark.reflect.Class quark_List_mdk_runtime_actors_Actor__ref = datawire_mdk_md.Root.quark_List_mdk_runtime_actors_Actor__md;
    public static quark.reflect.Class mdk_protocol_WSClient_ref = datawire_mdk_md.Root.mdk_protocol_WSClient_md;
    public io.datawire.quark.runtime.Logger logger = quark.Functions._getLogger("protocol");
    public Double firstDelay = 1.0;
    public Double maxDelay = 16.0;
    public Double reconnectDelay = this.firstDelay;
    public Double ttl = 30.0;
    public Double tick = 1.0;
    public mdk_runtime.WSActor sock = null;
    public Long lastConnectAttempt = 0L;
    public mdk_runtime.Time timeService;
    public mdk_runtime.actors.Actor schedulingActor;
    public mdk_runtime.WebSockets websockets;
    public mdk_runtime.actors.MessageDispatcher dispatcher;
    public String url;
    public String token;
    public java.util.ArrayList<mdk_runtime.actors.Actor> subscribers = new java.util.ArrayList(java.util.Arrays.asList(new Object[]{}));
    public Boolean _started = false;
    public JSONParser _parser;
    public WSClient(mdk_runtime.MDKRuntime runtime, JSONParser parser, String url, String token) {
        (this).dispatcher = (runtime).dispatcher;
        (this).timeService = (runtime).getTimeService();
        (this).schedulingActor = (runtime).getScheduleService();
        (this).websockets = (runtime).getWebSocketsService();
        (this).url = url;
        (this).token = token;
        (this)._parser = parser;
    }
    /**
     * Subscribe to messages from the server.
     *
     * Do this before starting the WSClient.
     *
     * The given Actor subscribes to WSConnected, all WSMessage received by the
     * WSClient, as well as a periodic Pump message.
     *
     */
    public void subscribe(mdk_runtime.actors.Actor subscriber) {
        ((this).subscribers).add(subscriber);
    }
    public Boolean isStarted() {
        return this._started;
    }
    public Boolean isConnected() {
        return !((this.sock)==(null) || ((Object)(this.sock) != null && ((Object) (this.sock)).equals(null)));
    }
    public void schedule(Double time) {
        ((this).dispatcher).tell(this, new mdk_runtime.Schedule("wakeup", time), (this).schedulingActor);
    }
    public void scheduleReconnect() {
        this.schedule(this.reconnectDelay);
    }
    /**
     * Called when the connection is closed via message by the server.
     */
    public void onClose(Boolean error) {
        (this.logger).info("close!");
        if (error) {
            this.doBackoff();
        } else {
            this.reconnectDelay = this.firstDelay;
        }
    }
    public void doBackoff() {
        this.reconnectDelay = (2.0) * (this.reconnectDelay);
        if ((this.reconnectDelay) > (this.maxDelay)) {
            this.reconnectDelay = this.maxDelay;
        }
        (this.logger).info((("backing off, reconnecting in ") + (Double.toString(this.reconnectDelay))) + (" seconds"));
    }
    public void onStart(mdk_runtime.actors.MessageDispatcher dispatcher) {
        (this)._started = true;
        this.schedule(0.0);
    }
    public void onStop() {
        (this)._started = false;
        if (this.isConnected()) {
            ((this).dispatcher).tell(this, new mdk_runtime.WSClose(), this.sock);
            this.sock = (mdk_runtime.WSActor) (null);
        }
    }
    public void onMessage(mdk_runtime.actors.Actor origin, Object message) {
        String typeId = (quark.reflect.Class.get(io.datawire.quark.runtime.Builtins._getClass(message))).id;
        if ((typeId)==("mdk_runtime.Happening") || ((Object)(typeId) != null && ((Object) (typeId)).equals("mdk_runtime.Happening"))) {
            (this).onScheduledEvent();
            return;
        }
        if ((typeId)==("mdk_runtime.WSClosed") || ((Object)(typeId) != null && ((Object) (typeId)).equals("mdk_runtime.WSClosed"))) {
            (this).onWSClosed();
            return;
        }
        if ((typeId)==("mdk_runtime.WSMessage") || ((Object)(typeId) != null && ((Object) (typeId)).equals("mdk_runtime.WSMessage"))) {
            mdk_runtime.WSMessage wsmessage = (mdk_runtime.WSMessage) (message);
            Object parsed = ((this)._parser).decode((wsmessage).body);
            if ((parsed)==(null) || ((Object)(parsed) != null && ((Object) (parsed)).equals(null))) {
                return;
            }
            DecodedMessage decoded = new DecodedMessage(parsed);
            Integer idx = 0;
            while ((idx) < (((this).subscribers).size())) {
                ((this).dispatcher).tell(this, decoded, ((this).subscribers).get(idx));
                idx = (idx) + (1);
            }
            return;
        }
    }
    public void onScheduledEvent() {
        Long rightNow = Math.round((((this).timeService).time()) * (1000.0));
        Long reconnectInterval = Math.round((this.reconnectDelay) * (1000.0));
        if (this.isConnected()) {
            if (this.isStarted()) {
                this.pump();
            }
        } else {
            if ((this.isStarted()) && (((rightNow) - (this.lastConnectAttempt)) >= (reconnectInterval))) {
                this.doOpen();
            }
        }
        if (this.isStarted()) {
            this.schedule(this.tick);
        }
    }
    public void doOpen() {
        this.lastConnectAttempt = Math.round((((this).timeService).time()) * (1000.0));
        String sockUrl = this.url;
        if (!((this.token)==(null) || ((Object)(this.token) != null && ((Object) (this.token)).equals(null)))) {
            sockUrl = ((sockUrl) + ("?token=")) + (this.token);
        }
        (this.logger).info(("opening ") + (this.url));
        (((this).websockets).connect(sockUrl, this)).andEither(new quark._BoundMethod(this, "onWSConnected", new java.util.ArrayList(java.util.Arrays.asList(new Object[]{}))), new quark._BoundMethod(this, "onWSError", new java.util.ArrayList(java.util.Arrays.asList(new Object[]{}))));
    }
    public void startup() {
        WSConnected message = new WSConnected((this).sock);
        Integer idx = 0;
        while ((idx) < ((this.subscribers).size())) {
            ((this).dispatcher).tell(this, message, (this.subscribers).get(idx));
            idx = (idx) + (1);
        }
    }
    public void pump() {
        Pump message = new Pump();
        Integer idx = 0;
        while ((idx) < ((this.subscribers).size())) {
            ((this).dispatcher).tell(this, message, (this.subscribers).get(idx));
            idx = (idx) + (1);
        }
    }
    public void onWSConnected(mdk_runtime.WSActor socket) {
        (this.logger).info(((("connected to ") + (this.url)) + (" via ")) + (("" + (socket))));
        this.reconnectDelay = this.firstDelay;
        this.sock = socket;
        this.startup();
        this.pump();
    }
    public void onWSError(quark.error.Error error) {
        (this.logger).error(("onWSError in protocol! ") + ((error).toString()));
        this.doBackoff();
    }
    public void onWSClosed() {
        (this.logger).info(("closed ") + (this.url));
        this.sock = (mdk_runtime.WSActor) (null);
    }
    public String _getClass() {
        return "mdk_protocol.WSClient";
    }
    public Object _getField(String name) {
        if ((name)==("logger") || ((Object)(name) != null && ((Object) (name)).equals("logger"))) {
            return (this).logger;
        }
        if ((name)==("firstDelay") || ((Object)(name) != null && ((Object) (name)).equals("firstDelay"))) {
            return (this).firstDelay;
        }
        if ((name)==("maxDelay") || ((Object)(name) != null && ((Object) (name)).equals("maxDelay"))) {
            return (this).maxDelay;
        }
        if ((name)==("reconnectDelay") || ((Object)(name) != null && ((Object) (name)).equals("reconnectDelay"))) {
            return (this).reconnectDelay;
        }
        if ((name)==("ttl") || ((Object)(name) != null && ((Object) (name)).equals("ttl"))) {
            return (this).ttl;
        }
        if ((name)==("tick") || ((Object)(name) != null && ((Object) (name)).equals("tick"))) {
            return (this).tick;
        }
        if ((name)==("sock") || ((Object)(name) != null && ((Object) (name)).equals("sock"))) {
            return (this).sock;
        }
        if ((name)==("lastConnectAttempt") || ((Object)(name) != null && ((Object) (name)).equals("lastConnectAttempt"))) {
            return (this).lastConnectAttempt;
        }
        if ((name)==("timeService") || ((Object)(name) != null && ((Object) (name)).equals("timeService"))) {
            return (this).timeService;
        }
        if ((name)==("schedulingActor") || ((Object)(name) != null && ((Object) (name)).equals("schedulingActor"))) {
            return (this).schedulingActor;
        }
        if ((name)==("websockets") || ((Object)(name) != null && ((Object) (name)).equals("websockets"))) {
            return (this).websockets;
        }
        if ((name)==("dispatcher") || ((Object)(name) != null && ((Object) (name)).equals("dispatcher"))) {
            return (this).dispatcher;
        }
        if ((name)==("url") || ((Object)(name) != null && ((Object) (name)).equals("url"))) {
            return (this).url;
        }
        if ((name)==("token") || ((Object)(name) != null && ((Object) (name)).equals("token"))) {
            return (this).token;
        }
        if ((name)==("subscribers") || ((Object)(name) != null && ((Object) (name)).equals("subscribers"))) {
            return (this).subscribers;
        }
        if ((name)==("_started") || ((Object)(name) != null && ((Object) (name)).equals("_started"))) {
            return (this)._started;
        }
        if ((name)==("_parser") || ((Object)(name) != null && ((Object) (name)).equals("_parser"))) {
            return (this)._parser;
        }
        return null;
    }
    public void _setField(String name, Object value) {
        if ((name)==("logger") || ((Object)(name) != null && ((Object) (name)).equals("logger"))) {
            (this).logger = (io.datawire.quark.runtime.Logger) (value);
        }
        if ((name)==("firstDelay") || ((Object)(name) != null && ((Object) (name)).equals("firstDelay"))) {
            (this).firstDelay = (Double) (value);
        }
        if ((name)==("maxDelay") || ((Object)(name) != null && ((Object) (name)).equals("maxDelay"))) {
            (this).maxDelay = (Double) (value);
        }
        if ((name)==("reconnectDelay") || ((Object)(name) != null && ((Object) (name)).equals("reconnectDelay"))) {
            (this).reconnectDelay = (Double) (value);
        }
        if ((name)==("ttl") || ((Object)(name) != null && ((Object) (name)).equals("ttl"))) {
            (this).ttl = (Double) (value);
        }
        if ((name)==("tick") || ((Object)(name) != null && ((Object) (name)).equals("tick"))) {
            (this).tick = (Double) (value);
        }
        if ((name)==("sock") || ((Object)(name) != null && ((Object) (name)).equals("sock"))) {
            (this).sock = (mdk_runtime.WSActor) (value);
        }
        if ((name)==("lastConnectAttempt") || ((Object)(name) != null && ((Object) (name)).equals("lastConnectAttempt"))) {
            (this).lastConnectAttempt = (Long) (value);
        }
        if ((name)==("timeService") || ((Object)(name) != null && ((Object) (name)).equals("timeService"))) {
            (this).timeService = (mdk_runtime.Time) (value);
        }
        if ((name)==("schedulingActor") || ((Object)(name) != null && ((Object) (name)).equals("schedulingActor"))) {
            (this).schedulingActor = (mdk_runtime.actors.Actor) (value);
        }
        if ((name)==("websockets") || ((Object)(name) != null && ((Object) (name)).equals("websockets"))) {
            (this).websockets = (mdk_runtime.WebSockets) (value);
        }
        if ((name)==("dispatcher") || ((Object)(name) != null && ((Object) (name)).equals("dispatcher"))) {
            (this).dispatcher = (mdk_runtime.actors.MessageDispatcher) (value);
        }
        if ((name)==("url") || ((Object)(name) != null && ((Object) (name)).equals("url"))) {
            (this).url = (String) (value);
        }
        if ((name)==("token") || ((Object)(name) != null && ((Object) (name)).equals("token"))) {
            (this).token = (String) (value);
        }
        if ((name)==("subscribers") || ((Object)(name) != null && ((Object) (name)).equals("subscribers"))) {
            (this).subscribers = (java.util.ArrayList<mdk_runtime.actors.Actor>) (value);
        }
        if ((name)==("_started") || ((Object)(name) != null && ((Object) (name)).equals("_started"))) {
            (this)._started = (Boolean) (value);
        }
        if ((name)==("_parser") || ((Object)(name) != null && ((Object) (name)).equals("_parser"))) {
            (this)._parser = (JSONParser) (value);
        }
    }
}
