/* Quark 1.0.452 run at 2016-10-24 14:33:24.783025 */
package mdk_protocol;

public class SharedContext extends Serializable implements io.datawire.quark.runtime.QObject {
    public static quark.reflect.Class mdk_protocol_SharedContext_ref = datawire_mdk_md.Root.mdk_protocol_SharedContext_md;
    /**
     * Every SharedContext is given an ID at the moment of its
     * creation; this is its traceId. Every operation started
     * as a result of the thing that caused the SharedContext to
     * be created must use the same SharedContext, and its
     * traceId will _never_ _change_.
     *
     */
    public String traceId = (quark.concurrent.Context.runtime()).uuid();
    /**
     * To track causality, we use a Lamport clock.
     *
     */
    public LamportClock clock = new LamportClock();
    /**
     * We also provide a map of properties for later extension. Rememeber
     * that these, too, will be shared across the whole system.
     *
     */
    public java.util.HashMap<String,Object> properties = io.datawire.quark.runtime.Builtins.map(new Object[]{});
    public Integer _lastEntry = 0;
    public SharedContext() {
        super();
        (this)._lastEntry = ((this).clock).enter();
    }
    /**
     * Set the traceId for this SharedContext.
     */
    public SharedContext withTraceId(String traceId) {
        (this).traceId = traceId;
        return this;
    }
    public static SharedContext decode(String encoded) {
        return (SharedContext) (Serializable.decodeClassName("mdk_protocol.SharedContext", encoded));
    }
    public String clockStr(String pfx) {
        String cs = "";
        if (!(((this).clock)==(null) || ((Object)((this).clock) != null && ((Object) ((this).clock)).equals(null)))) {
            cs = (pfx) + (((this).clock).key());
        }
        return cs;
    }
    public String key() {
        return ((this).traceId) + ((this).clockStr(":"));
    }
    public String toString() {
        return ((("<SCTX t:") + ((this).traceId)) + ((this).clockStr(" c:"))) + (">");
    }
    /**
     * Tick the clock at our current causality level.
     *
     */
    public void tick() {
        ((this).clock).tick();
    }
    /**
     * Return a SharedContext one level deeper in causality.
     *
     * NOTE WELL: THIS RETURNS A NEW SharedContext RATHER THAN MODIFYING THIS ONE. It is NOT SUPPORTED
     * to modify the causality level of a SharedContext in place.
     *
     */
    public SharedContext start_span() {
        (this).tick();
        SharedContext newContext = SharedContext.decode((this).encode());
        (newContext)._lastEntry = ((newContext).clock).enter();
        return newContext;
    }
    /**
     * Return a SharedContext one level higher in causality. In practice, most callers should probably stop
     * using this context, and the new one, after calling this method.
     *
     * NOTE WELL: THIS RETURNS A NEW SharedContext RATHER THAN MODIFYING THIS ONE. It is NOT SUPPORTED
     * to modify the causality level of a SharedContext in place.
     *
     */
    public SharedContext finish_span() {
        SharedContext newContext = SharedContext.decode((this).encode());
        (newContext)._lastEntry = ((newContext).clock).leave((newContext)._lastEntry);
        return newContext;
    }
    /**
     * Return a copy of a SharedContext.
     */
    public SharedContext copy() {
        return SharedContext.decode((this).encode());
    }
    public String _getClass() {
        return "mdk_protocol.SharedContext";
    }
    public Object _getField(String name) {
        if ((name)==("traceId") || ((Object)(name) != null && ((Object) (name)).equals("traceId"))) {
            return (this).traceId;
        }
        if ((name)==("clock") || ((Object)(name) != null && ((Object) (name)).equals("clock"))) {
            return (this).clock;
        }
        if ((name)==("properties") || ((Object)(name) != null && ((Object) (name)).equals("properties"))) {
            return (this).properties;
        }
        if ((name)==("_lastEntry") || ((Object)(name) != null && ((Object) (name)).equals("_lastEntry"))) {
            return (this)._lastEntry;
        }
        return null;
    }
    public void _setField(String name, Object value) {
        if ((name)==("traceId") || ((Object)(name) != null && ((Object) (name)).equals("traceId"))) {
            (this).traceId = (String) (value);
        }
        if ((name)==("clock") || ((Object)(name) != null && ((Object) (name)).equals("clock"))) {
            (this).clock = (LamportClock) (value);
        }
        if ((name)==("properties") || ((Object)(name) != null && ((Object) (name)).equals("properties"))) {
            (this).properties = (java.util.HashMap<String,Object>) (value);
        }
        if ((name)==("_lastEntry") || ((Object)(name) != null && ((Object) (name)).equals("_lastEntry"))) {
            (this)._lastEntry = (Integer) (value);
        }
    }
}
