/* Quark 1.0.452 run at 2016-10-24 14:33:24.783025 */
package mdk_protocol;

/**
 * A Lamport Clock is a logical structure meant to allow partial causal ordering. Ours is a list of
 * integers such that adding an integer implies adding a new level to the causality tree.
 *
 * Within a level, time is indicated by incrementing the clock, so
 *
 * [1,2,3] comes before [1,2,4] which comes before [1,2,5]
 *
 * Adding an element to the clock implies causality, so [1,2,4,1-N] is _by definition_ a sequence that was
 * _caused by_ the sequence of [1,2,1-3].
 *
 * Note that LamportClock is lowish-level support. SharedContext puts some more structure around this, too.
 *
 */
public class LamportClock extends Serializable implements io.datawire.quark.runtime.QObject {
    public static quark.reflect.Class quark_List_quark_int__ref = datawire_mdk_md.Root.quark_List_quark_int__md;
    public static quark.reflect.Class mdk_protocol_LamportClock_ref = datawire_mdk_md.Root.mdk_protocol_LamportClock_md;
    public io.datawire.quark.runtime.Lock _mutex = new io.datawire.quark.runtime.Lock();
    public java.util.ArrayList<Integer> clocks = new java.util.ArrayList(java.util.Arrays.asList(new Object[]{}));
    public LamportClock() {
        super();
    }
    public static LamportClock decode(String encoded) {
        return (LamportClock) (Serializable.decodeClassName("mdk_protocol.LamportClock", encoded));
    }
    /**
     * Return a neatly-formatted list of all of our clock elements (e.g. 1,2,4,1) for use as a name or
     * a key.
     *
     */
    public String key() {
        (this._mutex).acquire();
        java.util.ArrayList<String> tmp = new java.util.ArrayList(java.util.Arrays.asList(new Object[]{}));
        Integer i = 0;
        while ((i) < (((this).clocks).size())) {
            (tmp).add(Integer.toString(((this).clocks).get(i)));
            i = (i) + (1);
        }
        String str = io.datawire.quark.runtime.Builtins.join((","), (tmp));
        (this._mutex).release();
        return str;
    }
    public String toString() {
        (this._mutex).acquire();
        String str = (("<LamportClock ") + ((this).key())) + (">");
        (this._mutex).release();
        return str;
    }
    /**
     * Enter a new level of causality. Returns the value to pass to later pass to leave to get back to the
     * current level of causality.
     *
     */
    public Integer enter() {
        (this._mutex).acquire();
        Integer current = -(1);
        ((this).clocks).add(0);
        current = ((this).clocks).size();
        (this._mutex).release();
        return current;
    }
    /**
     * Leave deeper levels of causality. popTo should be the value returned when you enter()d this level.
     *
     */
    public Integer leave(Integer popTo) {
        (this._mutex).acquire();
        Integer current = -(1);
        (this).clocks = (new quark.ListUtil<Integer>()).slice((this).clocks, 0, popTo);
        current = ((this).clocks).size();
        (this._mutex).release();
        return current;
    }
    /**
     * Increment the clock for our current level of causality (which is always the last element in the list).
     * If there are no elements in our clock, do nothing.
     *
     */
    public void tick() {
        (this._mutex).acquire();
        Integer current = ((this).clocks).size();
        if ((current) > (0)) {
            ((this).clocks).set(((current) - (1)), ((((this).clocks).get((current) - (1))) + (1)));
        }
        (this._mutex).release();
    }
    public String _getClass() {
        return "mdk_protocol.LamportClock";
    }
    public Object _getField(String name) {
        if ((name)==("_mutex") || ((Object)(name) != null && ((Object) (name)).equals("_mutex"))) {
            return (this)._mutex;
        }
        if ((name)==("clocks") || ((Object)(name) != null && ((Object) (name)).equals("clocks"))) {
            return (this).clocks;
        }
        return null;
    }
    public void _setField(String name, Object value) {
        if ((name)==("_mutex") || ((Object)(name) != null && ((Object) (name)).equals("_mutex"))) {
            (this)._mutex = (io.datawire.quark.runtime.Lock) (value);
        }
        if ((name)==("clocks") || ((Object)(name) != null && ((Object) (name)).equals("clocks"))) {
            (this).clocks = (java.util.ArrayList<Integer>) (value);
        }
    }
}
