/* Quark 1.0.452 run at 2016-10-24 14:33:24.783025 */
package mdk_introspection;

public class Platform implements io.datawire.quark.runtime.QObject {
    public static String PLATFORM_TYPE_VARIABLE_NAME = "DATAWIRE_PLATFORM_TYPE";
    public static String PLATFORM_TYPE_EC2 = "EC2";
    public static String PLATFORM_TYPE_GOOGLE_COMPUTE = "GOOGLE_COMPUTE";
    public static String PLATFORM_TYPE_GOOGLE_CONTAINER = "GOOGLE_CONTAINER";
    public static String PLATFORM_TYPE_KUBERNETES = "Kubernetes";
    public static String ROUTABLE_HOST_VARIABLE_NAME = "DATAWIRE_ROUTABLE_HOST";
    public static String ROUTABLE_PORT_VARIABLE_NAME = "DATAWIRE_ROUTABLE_PORT";
    public static quark.reflect.Class mdk_introspection_Platform_ref = datawire_mdk_md.Root.mdk_introspection_Platform_md;
    public Platform() {}
    public static String platformType(mdk_runtime.EnvironmentVariables env) {
        String result = ((env).var(Platform.PLATFORM_TYPE_VARIABLE_NAME)).get();
        if (!((result)==(null) || ((Object)(result) != null && ((Object) (result)).equals(null)))) {
            result = (result).toUpperCase();
        }
        return result;
    }
    /**
     * Returns the routable hostname or IP for this service instance.
     * This method always returns the value of the environment variable DATAWIRE_ROUTABLE_HOST if it is defined.
     */
    public static String getRoutableHost(mdk_runtime.EnvironmentVariables env) {
        String result = (String) (null);
        io.datawire.quark.runtime.Logger logger = quark.Functions._getLogger("Platform");
        if (((env).var(Platform.ROUTABLE_HOST_VARIABLE_NAME)).isDefined()) {
            (logger).debug((("Using value in environment variable '") + (Platform.ROUTABLE_HOST_VARIABLE_NAME)) + ("'"));
            result = ((env).var(Platform.ROUTABLE_HOST_VARIABLE_NAME)).get();
        } else {
            if ((Platform.platformType(env))==(null) || ((Object)(Platform.platformType(env)) != null && ((Object) (Platform.platformType(env))).equals(null))) {
                (logger).error((("Platform type not specified in environment variable '") + (Platform.PLATFORM_TYPE_VARIABLE_NAME)) + ("'"));
                (quark.concurrent.Context.runtime()).fail("Environment variable 'DATAWIRE_PLATFORM_TYPE' is not set.");
            }
            if (Boolean.valueOf((Platform.platformType(env)).startsWith(Platform.PLATFORM_TYPE_EC2))) {
                (logger).debug((Platform.PLATFORM_TYPE_VARIABLE_NAME) + (" = EC2"));
                java.util.ArrayList<String> parts = new java.util.ArrayList<String>(java.util.Arrays.asList((Platform.platformType(env)).split(java.util.regex.Pattern.quote(":"), -1)));
                (logger).debug(("Platform Scope = ") + ((parts).get(1)));
                if (((parts).size())==(2) || ((Object)((parts).size()) != null && ((Object) ((parts).size())).equals(2))) {
                    return (new mdk_introspection.aws.Ec2Host(env, (parts).get(1))).get();
                } else {
                    (logger).error((("Invalid format for '") + (Platform.PLATFORM_TYPE_VARIABLE_NAME)) + ("' starting with 'ec2'. Expected (ec2:<scope>)"));
                    (quark.concurrent.Context.runtime()).fail("Invalid format for DATAWIRE_PLATFORM_TYPE == EC2. Expected EC2:<scope>.");
                }
            }
        }
        return result;
    }
    /**
     * Returns the routable port number for this service instance or uses the provided port if a value cannot be resolved.
     * This method always returns the value of the environment variable DATAWIRE_ROUTABLE_PORT if it is defined.
     */
    public static Integer getRoutablePort(mdk_runtime.EnvironmentVariables env, Integer servicePort) {
        if (((env).var(Platform.ROUTABLE_PORT_VARIABLE_NAME)).isDefined()) {
            return Integer.parseInt(((env).var(Platform.ROUTABLE_PORT_VARIABLE_NAME)).get());
        }
        if ((Platform.platformType(env))==(Platform.PLATFORM_TYPE_KUBERNETES) || ((Object)(Platform.platformType(env)) != null && ((Object) (Platform.platformType(env))).equals(Platform.PLATFORM_TYPE_KUBERNETES))) {
            return (new mdk_introspection.kubernetes.KubernetesPort()).get();
        }
        return servicePort;
    }
    public String _getClass() {
        return "mdk_introspection.Platform";
    }
    public Object _getField(String name) {
        if ((name)==("PLATFORM_TYPE_VARIABLE_NAME") || ((Object)(name) != null && ((Object) (name)).equals("PLATFORM_TYPE_VARIABLE_NAME"))) {
            return Platform.PLATFORM_TYPE_VARIABLE_NAME;
        }
        if ((name)==("PLATFORM_TYPE_EC2") || ((Object)(name) != null && ((Object) (name)).equals("PLATFORM_TYPE_EC2"))) {
            return Platform.PLATFORM_TYPE_EC2;
        }
        if ((name)==("PLATFORM_TYPE_GOOGLE_COMPUTE") || ((Object)(name) != null && ((Object) (name)).equals("PLATFORM_TYPE_GOOGLE_COMPUTE"))) {
            return Platform.PLATFORM_TYPE_GOOGLE_COMPUTE;
        }
        if ((name)==("PLATFORM_TYPE_GOOGLE_CONTAINER") || ((Object)(name) != null && ((Object) (name)).equals("PLATFORM_TYPE_GOOGLE_CONTAINER"))) {
            return Platform.PLATFORM_TYPE_GOOGLE_CONTAINER;
        }
        if ((name)==("PLATFORM_TYPE_KUBERNETES") || ((Object)(name) != null && ((Object) (name)).equals("PLATFORM_TYPE_KUBERNETES"))) {
            return Platform.PLATFORM_TYPE_KUBERNETES;
        }
        if ((name)==("ROUTABLE_HOST_VARIABLE_NAME") || ((Object)(name) != null && ((Object) (name)).equals("ROUTABLE_HOST_VARIABLE_NAME"))) {
            return Platform.ROUTABLE_HOST_VARIABLE_NAME;
        }
        if ((name)==("ROUTABLE_PORT_VARIABLE_NAME") || ((Object)(name) != null && ((Object) (name)).equals("ROUTABLE_PORT_VARIABLE_NAME"))) {
            return Platform.ROUTABLE_PORT_VARIABLE_NAME;
        }
        return null;
    }
    public void _setField(String name, Object value) {
        if ((name)==("PLATFORM_TYPE_VARIABLE_NAME") || ((Object)(name) != null && ((Object) (name)).equals("PLATFORM_TYPE_VARIABLE_NAME"))) {
            Platform.PLATFORM_TYPE_VARIABLE_NAME = (String) (value);
        }
        if ((name)==("PLATFORM_TYPE_EC2") || ((Object)(name) != null && ((Object) (name)).equals("PLATFORM_TYPE_EC2"))) {
            Platform.PLATFORM_TYPE_EC2 = (String) (value);
        }
        if ((name)==("PLATFORM_TYPE_GOOGLE_COMPUTE") || ((Object)(name) != null && ((Object) (name)).equals("PLATFORM_TYPE_GOOGLE_COMPUTE"))) {
            Platform.PLATFORM_TYPE_GOOGLE_COMPUTE = (String) (value);
        }
        if ((name)==("PLATFORM_TYPE_GOOGLE_CONTAINER") || ((Object)(name) != null && ((Object) (name)).equals("PLATFORM_TYPE_GOOGLE_CONTAINER"))) {
            Platform.PLATFORM_TYPE_GOOGLE_CONTAINER = (String) (value);
        }
        if ((name)==("PLATFORM_TYPE_KUBERNETES") || ((Object)(name) != null && ((Object) (name)).equals("PLATFORM_TYPE_KUBERNETES"))) {
            Platform.PLATFORM_TYPE_KUBERNETES = (String) (value);
        }
        if ((name)==("ROUTABLE_HOST_VARIABLE_NAME") || ((Object)(name) != null && ((Object) (name)).equals("ROUTABLE_HOST_VARIABLE_NAME"))) {
            Platform.ROUTABLE_HOST_VARIABLE_NAME = (String) (value);
        }
        if ((name)==("ROUTABLE_PORT_VARIABLE_NAME") || ((Object)(name) != null && ((Object) (name)).equals("ROUTABLE_PORT_VARIABLE_NAME"))) {
            Platform.ROUTABLE_PORT_VARIABLE_NAME = (String) (value);
        }
    }
}
