/* Quark 1.0.452 run at 2016-10-24 14:33:24.783025 */
package mdk_discovery.synapse;

/**
 * Implementation of the Synapse discovery source.
 */
public class _SynapseSource implements mdk_discovery.DiscoverySource, io.datawire.quark.runtime.QObject {
    public static quark.reflect.Class mdk_discovery_synapse__SynapseSource_ref = datawire_mdk_md.Root.mdk_discovery_synapse__SynapseSource_md;
    public mdk_runtime.actors.Actor subscriber;
    public String directory_path;
    public mdk_runtime.files.FileActor files;
    public mdk_runtime.actors.MessageDispatcher dispatcher;
    public _SynapseSource(mdk_runtime.actors.Actor subscriber, String directory_path, mdk_runtime.MDKRuntime runtime) {
        (this).subscriber = subscriber;
        (this).directory_path = directory_path;
        (this).files = (runtime).getFileService();
    }
    public void onStart(mdk_runtime.actors.MessageDispatcher dispatcher) {
        (this).dispatcher = dispatcher;
        ((this).dispatcher).tell(this, new mdk_runtime.files.SubscribeChanges((this).directory_path), (this).files);
    }
    /**
     * Convert '/path/to/service_name.json' to 'service_name'.
     */
    public String _pathToServiceName(String filename) {
        java.util.ArrayList<String> parts = new java.util.ArrayList<String>(java.util.Arrays.asList((filename).split(java.util.regex.Pattern.quote("/"), -1)));
        String service = (parts).get(((parts).size()) - (1));
        return (service).substring((0), (((service).length()) - (5)));
    }
    /**
     * Send an appropriate update to the subscriber for this DiscoverySource.
     */
    public void _update(String service, java.util.ArrayList<mdk_discovery.Node> nodes) {
        ((this).dispatcher).tell(this, new mdk_discovery.ReplaceCluster(service, nodes), (this).subscriber);
    }
    public void onMessage(mdk_runtime.actors.Actor origin, Object message) {
        String typeId = (quark.reflect.Class.get(io.datawire.quark.runtime.Builtins._getClass(message))).id;
        String service;
        if ((typeId)==("mdk_runtime.files.FileContents") || ((Object)(typeId) != null && ((Object) (typeId)).equals("mdk_runtime.files.FileContents"))) {
            mdk_runtime.files.FileContents contents = (mdk_runtime.files.FileContents) (message);
            if (!(Boolean.valueOf(((contents).path).endsWith(".json")))) {
                return;
            }
            service = (this)._pathToServiceName((contents).path);
            io.datawire.quark.runtime.JSONObject json = io.datawire.quark.runtime.JSONObject.parse((contents).contents);
            java.util.ArrayList<mdk_discovery.Node> nodes = new java.util.ArrayList(java.util.Arrays.asList(new Object[]{}));
            Integer idx = 0;
            while ((idx) < ((json).size())) {
                io.datawire.quark.runtime.JSONObject entry = (json).getListItem(idx);
                mdk_discovery.Node node = new mdk_discovery.Node();
                (node).service = service;
                (node).version = "1.0";
                String host = ((entry).getObjectItem("host")).getString();
                String port = Long.toString(Math.round(((entry).getObjectItem("port")).getNumber()));
                (node).address = ((host) + (":")) + (port);
                (nodes).add(node);
                idx = (idx) + (1);
            }
            (this)._update(service, nodes);
            return;
        }
        if ((typeId)==("mdk_runtime.files.FileDeleted") || ((Object)(typeId) != null && ((Object) (typeId)).equals("mdk_runtime.files.FileDeleted"))) {
            mdk_runtime.files.FileDeleted deleted = (mdk_runtime.files.FileDeleted) (message);
            service = (this)._pathToServiceName((deleted).path);
            (this)._update(service, new java.util.ArrayList(java.util.Arrays.asList(new Object[]{})));
            return;
        }
    }
    public String _getClass() {
        return "mdk_discovery.synapse._SynapseSource";
    }
    public Object _getField(String name) {
        if ((name)==("subscriber") || ((Object)(name) != null && ((Object) (name)).equals("subscriber"))) {
            return (this).subscriber;
        }
        if ((name)==("directory_path") || ((Object)(name) != null && ((Object) (name)).equals("directory_path"))) {
            return (this).directory_path;
        }
        if ((name)==("files") || ((Object)(name) != null && ((Object) (name)).equals("files"))) {
            return (this).files;
        }
        if ((name)==("dispatcher") || ((Object)(name) != null && ((Object) (name)).equals("dispatcher"))) {
            return (this).dispatcher;
        }
        return null;
    }
    public void _setField(String name, Object value) {
        if ((name)==("subscriber") || ((Object)(name) != null && ((Object) (name)).equals("subscriber"))) {
            (this).subscriber = (mdk_runtime.actors.Actor) (value);
        }
        if ((name)==("directory_path") || ((Object)(name) != null && ((Object) (name)).equals("directory_path"))) {
            (this).directory_path = (String) (value);
        }
        if ((name)==("files") || ((Object)(name) != null && ((Object) (name)).equals("files"))) {
            (this).files = (mdk_runtime.files.FileActor) (value);
        }
        if ((name)==("dispatcher") || ((Object)(name) != null && ((Object) (name)).equals("dispatcher"))) {
            (this).dispatcher = (mdk_runtime.actors.MessageDispatcher) (value);
        }
    }
    /**
     * The Actor should begin shutting down.
     */
    public void onStop() {}
}
