/* Quark 1.0.452 run at 2016-10-24 14:33:24.783025 */
package mdk_discovery.synapse;

/**
 * AirBnB Synapse discovery source.
 *
 * Reads Synapse-generated files (https://github.com/airbnb/synapse#file) and
 * generates discovery events.
 *
 * Usage:
 *
 * m = mdk.init()
 * m.registerDiscoverySource(Synapse('/path/to/synapse/files'))
 * m.start()
 *
 * All resulting Node instances will have version '1.0' hardcoded, and an
 * address of the form 'host:port'.
 *
 * The original object from Synpase will be attached as the Node's properties.
 *
 */
public class Synapse implements mdk_discovery.DiscoverySourceFactory, io.datawire.quark.runtime.QObject {
    public static quark.reflect.Class mdk_discovery_synapse_Synapse_ref = datawire_mdk_md.Root.mdk_discovery_synapse_Synapse_md;
    public String _directory_path;
    public Synapse(String directory_path) {
        (this)._directory_path = directory_path;
    }
    public mdk_discovery.DiscoverySource create(mdk_runtime.actors.Actor subscriber, mdk_runtime.MDKRuntime runtime) {
        return new _SynapseSource(subscriber, (this)._directory_path, runtime);
    }
    public Boolean isRegistrar() {
        return false;
    }
    public String _getClass() {
        return "mdk_discovery.synapse.Synapse";
    }
    public Object _getField(String name) {
        if ((name)==("_directory_path") || ((Object)(name) != null && ((Object) (name)).equals("_directory_path"))) {
            return (this)._directory_path;
        }
        return null;
    }
    public void _setField(String name, Object value) {
        if ((name)==("_directory_path") || ((Object)(name) != null && ((Object) (name)).equals("_directory_path"))) {
            (this)._directory_path = (String) (value);
        }
    }
}
