/* Quark 1.0.452 run at 2016-10-24 14:33:24.783025 */
package mdk_discovery.protocol;

/**
 * A source of discovery information that talks to Datawire Discovery server.
 *
 * Also supports registering discovery information with the server.
 *
 */
public class DiscoClient implements mdk_protocol.WSClientSubscriber, mdk_discovery.DiscoverySource, mdk_discovery.DiscoveryRegistrar, io.datawire.quark.runtime.QObject {
    public static quark.reflect.Class mdk_discovery_protocol_DiscoClient_ref = datawire_mdk_md.Root.mdk_discovery_protocol_DiscoClient_md;
    public mdk_discovery.FailurePolicyFactory _failurePolicyFactory;
    public mdk_runtime.actors.MessageDispatcher _dispatcher;
    public mdk_runtime.Time _timeService;
    public mdk_runtime.actors.Actor _subscriber;
    public mdk_protocol.WSClient _wsclient;
    public java.util.HashMap<String,mdk_discovery.Cluster> registered = new java.util.HashMap<String,mdk_discovery.Cluster>();
    public io.datawire.quark.runtime.Logger dlog = quark.Functions._getLogger("discovery");
    public Long lastHeartbeat = 0L;
    public mdk_runtime.actors.Actor sock;
    public DiscoClient(mdk_runtime.actors.Actor disco_subscriber, mdk_protocol.WSClient wsclient, mdk_runtime.MDKRuntime runtime) {
        (this)._subscriber = disco_subscriber;
        (this)._wsclient = wsclient;
        ((this)._wsclient).subscribe(this);
        (this)._failurePolicyFactory = (mdk_discovery.FailurePolicyFactory) (((runtime).dependencies).getService("failurepolicy_factory"));
        (this)._timeService = (runtime).getTimeService();
    }
    public void onStart(mdk_runtime.actors.MessageDispatcher dispatcher) {
        (this)._dispatcher = dispatcher;
    }
    public void onStop() {
        this.shutdown();
    }
    public void onMessage(mdk_runtime.actors.Actor origin, Object message) {
        String klass = (quark.reflect.Class.get(io.datawire.quark.runtime.Builtins._getClass(message))).id;
        if ((klass)==("mdk_discovery.RegisterNode") || ((Object)(klass) != null && ((Object) (klass)).equals("mdk_discovery.RegisterNode"))) {
            mdk_discovery.RegisterNode register = (mdk_discovery.RegisterNode) (message);
            this._register((register).node);
            return;
        }
        mdk_protocol.Functions._subscriberDispatch(this, message);
    }
    public void onMessageFromServer(Object message) {
        String type = (quark.reflect.Class.get(io.datawire.quark.runtime.Builtins._getClass(message))).id;
        if ((type)==("mdk_discovery.protocol.Active") || ((Object)(type) != null && ((Object) (type)).equals("mdk_discovery.protocol.Active"))) {
            Active active = (Active) (message);
            this.onActive(active);
            return;
        }
        if ((type)==("mdk_discovery.protocol.Expire") || ((Object)(type) != null && ((Object) (type)).equals("mdk_discovery.protocol.Expire"))) {
            Expire expire = (Expire) (message);
            (this).onExpire(expire);
            return;
        }
    }
    public void onWSConnected(mdk_runtime.actors.Actor websocket) {
        (this).sock = websocket;
        this.heartbeat();
    }
    public void onPump() {
        Long rightNow = Math.round((((this)._timeService).time()) * (1000.0));
        Long heartbeatInterval = Math.round(((((this)._wsclient).ttl) / (2.0)) * (1000.0));
        if (((rightNow) - ((this).lastHeartbeat)) >= (heartbeatInterval)) {
            (this).lastHeartbeat = rightNow;
            this.heartbeat();
        }
    }
    /**
     * Register a node with the remote Discovery server.
     */
    public void _register(mdk_discovery.Node node) {
        String service = (node).service;
        if (!((this.registered).containsKey(service))) {
            (this.registered).put((service), (new mdk_discovery.Cluster((this)._failurePolicyFactory)));
        }
        ((this.registered).get(service)).add(node);
        if (((this)._wsclient).isConnected()) {
            this.active(node);
        }
    }
    public void active(mdk_discovery.Node node) {
        Active active = new Active();
        (active).node = node;
        (active).ttl = ((this)._wsclient).ttl;
        ((this)._dispatcher).tell(this, (active).encode(), (this).sock);
        (this.dlog).info(("active ") + ((node).toString()));
    }
    public void expire(mdk_discovery.Node node) {
        Expire expire = new Expire();
        (expire).node = node;
        ((this)._dispatcher).tell(this, (expire).encode(), (this).sock);
        (this.dlog).info(("expire ") + ((node).toString()));
    }
    public void resolve(mdk_discovery.Node node) {}
    public void onActive(Active active) {
        ((this)._dispatcher).tell(this, new mdk_discovery.NodeActive((active).node), (this)._subscriber);
    }
    public void onExpire(Expire expire) {
        ((this)._dispatcher).tell(this, new mdk_discovery.NodeExpired((expire).node), (this)._subscriber);
    }
    /**
     * Send all registered services.
     */
    public void heartbeat() {
        java.util.ArrayList<String> services = new java.util.ArrayList(((this).registered).keySet());
        Integer idx = 0;
        while ((idx) < ((services).size())) {
            Integer jdx = 0;
            java.util.ArrayList<mdk_discovery.Node> nodes = (((this).registered).get((services).get(idx))).nodes;
            while ((jdx) < ((nodes).size())) {
                this.active((nodes).get(jdx));
                jdx = (jdx) + (1);
            }
            idx = (idx) + (1);
        }
    }
    public void shutdown() {
        java.util.ArrayList<String> services = new java.util.ArrayList(((this).registered).keySet());
        Integer idx = 0;
        while ((idx) < ((services).size())) {
            Integer jdx = 0;
            java.util.ArrayList<mdk_discovery.Node> nodes = (((this).registered).get((services).get(idx))).nodes;
            while ((jdx) < ((nodes).size())) {
                this.expire((nodes).get(jdx));
                jdx = (jdx) + (1);
            }
            idx = (idx) + (1);
        }
    }
    public String _getClass() {
        return "mdk_discovery.protocol.DiscoClient";
    }
    public Object _getField(String name) {
        if ((name)==("_failurePolicyFactory") || ((Object)(name) != null && ((Object) (name)).equals("_failurePolicyFactory"))) {
            return (this)._failurePolicyFactory;
        }
        if ((name)==("_dispatcher") || ((Object)(name) != null && ((Object) (name)).equals("_dispatcher"))) {
            return (this)._dispatcher;
        }
        if ((name)==("_timeService") || ((Object)(name) != null && ((Object) (name)).equals("_timeService"))) {
            return (this)._timeService;
        }
        if ((name)==("_subscriber") || ((Object)(name) != null && ((Object) (name)).equals("_subscriber"))) {
            return (this)._subscriber;
        }
        if ((name)==("_wsclient") || ((Object)(name) != null && ((Object) (name)).equals("_wsclient"))) {
            return (this)._wsclient;
        }
        if ((name)==("registered") || ((Object)(name) != null && ((Object) (name)).equals("registered"))) {
            return (this).registered;
        }
        if ((name)==("dlog") || ((Object)(name) != null && ((Object) (name)).equals("dlog"))) {
            return (this).dlog;
        }
        if ((name)==("lastHeartbeat") || ((Object)(name) != null && ((Object) (name)).equals("lastHeartbeat"))) {
            return (this).lastHeartbeat;
        }
        if ((name)==("sock") || ((Object)(name) != null && ((Object) (name)).equals("sock"))) {
            return (this).sock;
        }
        return null;
    }
    public void _setField(String name, Object value) {
        if ((name)==("_failurePolicyFactory") || ((Object)(name) != null && ((Object) (name)).equals("_failurePolicyFactory"))) {
            (this)._failurePolicyFactory = (mdk_discovery.FailurePolicyFactory) (value);
        }
        if ((name)==("_dispatcher") || ((Object)(name) != null && ((Object) (name)).equals("_dispatcher"))) {
            (this)._dispatcher = (mdk_runtime.actors.MessageDispatcher) (value);
        }
        if ((name)==("_timeService") || ((Object)(name) != null && ((Object) (name)).equals("_timeService"))) {
            (this)._timeService = (mdk_runtime.Time) (value);
        }
        if ((name)==("_subscriber") || ((Object)(name) != null && ((Object) (name)).equals("_subscriber"))) {
            (this)._subscriber = (mdk_runtime.actors.Actor) (value);
        }
        if ((name)==("_wsclient") || ((Object)(name) != null && ((Object) (name)).equals("_wsclient"))) {
            (this)._wsclient = (mdk_protocol.WSClient) (value);
        }
        if ((name)==("registered") || ((Object)(name) != null && ((Object) (name)).equals("registered"))) {
            (this).registered = (java.util.HashMap<String,mdk_discovery.Cluster>) (value);
        }
        if ((name)==("dlog") || ((Object)(name) != null && ((Object) (name)).equals("dlog"))) {
            (this).dlog = (io.datawire.quark.runtime.Logger) (value);
        }
        if ((name)==("lastHeartbeat") || ((Object)(name) != null && ((Object) (name)).equals("lastHeartbeat"))) {
            (this).lastHeartbeat = (Long) (value);
        }
        if ((name)==("sock") || ((Object)(name) != null && ((Object) (name)).equals("sock"))) {
            (this).sock = (mdk_runtime.actors.Actor) (value);
        }
    }
}
