/* Quark 1.0.452 run at 2016-10-24 14:33:24.783025 */
package mdk_discovery;

/**
 * The Discovery class functions as a conduit to a source of discovery information.
 * Using it, a provider can register itself as providing a particular service
 * (see the register method) and a consumer can locate a provider for a
 * particular service (see the resolve method).
 */
public class Discovery implements mdk_runtime.actors.Actor, io.datawire.quark.runtime.QObject {
    public static quark.reflect.Class quark_ListUtil_mdk_discovery_Node__ref = datawire_mdk_md.Root.quark_ListUtil_mdk_discovery_Node__md;
    public static quark.reflect.Class quark_Map_quark_String_mdk_discovery_Cluster__ref = datawire_mdk_md.Root.quark_Map_quark_String_mdk_discovery_Cluster__md;
    public static quark.reflect.Class mdk_discovery_Discovery_ref = datawire_mdk_md.Root.mdk_discovery_Discovery_md;
    public io.datawire.quark.runtime.Logger logger = quark.Functions._getLogger("discovery");
    public java.util.HashMap<String,Cluster> services = new java.util.HashMap<String,Cluster>();
    public Boolean started = false;
    public io.datawire.quark.runtime.Lock mutex = new io.datawire.quark.runtime.Lock();
    public mdk_runtime.MDKRuntime runtime;
    public FailurePolicyFactory _fpfactory;
    public Discovery(mdk_runtime.MDKRuntime runtime) {
        (this.logger).info("Discovery created!");
        (this).runtime = runtime;
        (this)._fpfactory = (FailurePolicyFactory) (((runtime).dependencies).getService("failurepolicy_factory"));
    }
    /**
     * Lock.
     */
    public void _lock() {
        (this.mutex).acquire();
    }
    public void _release() {
        (this.mutex).release();
    }
    /**
     * Start the uplink to the discovery service.
     */
    public void onStart(mdk_runtime.actors.MessageDispatcher dispatcher) {
        (this)._lock();
        if (!(this.started)) {
            this.started = true;
        }
        (this)._release();
    }
    /**
     * Stop the uplink to the discovery service.
     */
    public void onStop() {
        (this)._lock();
        if (this.started) {
            this.started = false;
        }
        (this)._release();
    }
    /**
     * Register info about a service node with a discovery source of truth. You must
     * usually start the uplink before this will do much; see start().
     */
    public Discovery register(Node node) {
        DiscoveryRegistrar registrar;
        if (((this.runtime).dependencies).hasService("discovery_registrar")) {
            registrar = (DiscoveryRegistrar) (((this.runtime).dependencies).getService("discovery_registrar"));
        } else {
            throw new RuntimeException("Registration not supported as no Discovery Registrar was setup.");
        }
        (((this).runtime).dispatcher).tell(this, new RegisterNode(node), registrar);
        return this;
    }
    /**
     * Register info about a service node with the discovery service. You must
     * usually start the uplink before this will do much; see start().
     */
    public Discovery register_service(String service, String address, String version) {
        Node node = new Node();
        (node).service = service;
        (node).address = address;
        (node).version = version;
        return (this).register(node);
    }
    /**
     * Return the current known Nodes for a service, if any.
     */
    public java.util.ArrayList<Node> knownNodes(String service) {
        if (!((this.services).containsKey(service))) {
            return new java.util.ArrayList(java.util.Arrays.asList(new Object[]{}));
        }
        return ((this.services).get(service)).nodes;
    }
    /**
     * Get the FailurePolicy for a Node.
     */
    public FailurePolicy failurePolicy(Node node) {
        return ((this.services).get((node).service)).failurePolicy(node);
    }
    /**
     * Resolve a service name into an available service node. You must
     * usually start the uplink before this will do much; see start().
     * The returned Promise will end up with a Node as its value.
     */
    public mdk_runtime.promise.Promise _resolve(String service, String version) {
        mdk_runtime.promise.PromiseResolver factory = new mdk_runtime.promise.PromiseResolver((this.runtime).dispatcher);
        (this)._lock();
        if (!((this.services).containsKey(service))) {
            (this.services).put((service), (new Cluster((this)._fpfactory)));
        }
        Node result = ((this.services).get(service)).chooseVersion(version);
        if ((result)==(null) || ((Object)(result) != null && ((Object) (result)).equals(null))) {
            ((this.services).get(service))._addRequest(version, factory);
            (this)._release();
        } else {
            (this)._release();
            (factory).resolve(result);
        }
        return (factory).promise;
    }
    /**
     * Resolve a service; return a (Bluebird) Promise on Javascript. Does not work elsewhere.
     */
    public Object resolve(String service, String version) {
        return mdk_util.Functions.toNativePromise(this._resolve(service, version));
    }
    /**
     * Wait for service name to resolve into an available service node, or fail
     * appropriately (typically by raising an exception if the language
     * supports it). This should only be used in blocking runtimes (e.g.
     * you do not want to use this in Javascript).
     */
    public Node resolve_until(String service, String version, Double timeout) {
        return (Node) (mdk_util.WaitForPromise.wait((this)._resolve(service, version), timeout, ("service ") + (service)));
    }
    public void onMessage(mdk_runtime.actors.Actor origin, Object message) {
        String klass = (quark.reflect.Class.get(io.datawire.quark.runtime.Builtins._getClass(message))).id;
        if ((klass)==("mdk_discovery.NodeActive") || ((Object)(klass) != null && ((Object) (klass)).equals("mdk_discovery.NodeActive"))) {
            NodeActive active = (NodeActive) (message);
            (this)._active((active).node);
            return;
        }
        if ((klass)==("mdk_discovery.NodeExpired") || ((Object)(klass) != null && ((Object) (klass)).equals("mdk_discovery.NodeExpired"))) {
            NodeExpired expire = (NodeExpired) (message);
            (this)._expire((expire).node);
            return;
        }
        if ((klass)==("mdk_discovery.ReplaceCluster") || ((Object)(klass) != null && ((Object) (klass)).equals("mdk_discovery.ReplaceCluster"))) {
            ReplaceCluster replace = (ReplaceCluster) (message);
            (this)._replace((replace).cluster, (replace).nodes);
            return;
        }
    }
    public void _replace(String service, java.util.ArrayList<Node> nodes) {
        (this)._lock();
        (this.logger).info(((("replacing all nodes for ") + (service)) + (" with ")) + (("" + (nodes))));
        if (!((this.services).containsKey(service))) {
            (this.services).put((service), (new Cluster((this)._fpfactory)));
        }
        Cluster cluster = (this.services).get(service);
        java.util.ArrayList<Node> currentNodes = (new quark.ListUtil<Node>()).slice((cluster).nodes, 0, ((cluster).nodes).size());
        Integer idx = 0;
        while ((idx) < ((currentNodes).size())) {
            (cluster).remove((currentNodes).get(idx));
            idx = (idx) + (1);
        }
        idx = 0;
        while ((idx) < ((nodes).size())) {
            (cluster).add((nodes).get(idx));
            idx = (idx) + (1);
        }
        (this)._release();
    }
    public void _active(Node node) {
        (this)._lock();
        String service = (node).service;
        (this.logger).info(("adding ") + ((node).toString()));
        if (!((this.services).containsKey(service))) {
            (this.services).put((service), (new Cluster((this)._fpfactory)));
        }
        Cluster cluster = (this.services).get(service);
        (cluster).add(node);
        (this)._release();
    }
    public void _expire(Node node) {
        (this)._lock();
        String service = (node).service;
        if ((this.services).containsKey(service)) {
            Cluster cluster = (this.services).get(service);
            (this.logger).info((("removing ") + ((node).toString())) + (" from cluster"));
            (cluster).remove(node);
        }
        (this)._release();
    }
    public String _getClass() {
        return "mdk_discovery.Discovery";
    }
    public Object _getField(String name) {
        if ((name)==("logger") || ((Object)(name) != null && ((Object) (name)).equals("logger"))) {
            return (this).logger;
        }
        if ((name)==("services") || ((Object)(name) != null && ((Object) (name)).equals("services"))) {
            return (this).services;
        }
        if ((name)==("started") || ((Object)(name) != null && ((Object) (name)).equals("started"))) {
            return (this).started;
        }
        if ((name)==("mutex") || ((Object)(name) != null && ((Object) (name)).equals("mutex"))) {
            return (this).mutex;
        }
        if ((name)==("runtime") || ((Object)(name) != null && ((Object) (name)).equals("runtime"))) {
            return (this).runtime;
        }
        if ((name)==("_fpfactory") || ((Object)(name) != null && ((Object) (name)).equals("_fpfactory"))) {
            return (this)._fpfactory;
        }
        return null;
    }
    public void _setField(String name, Object value) {
        if ((name)==("logger") || ((Object)(name) != null && ((Object) (name)).equals("logger"))) {
            (this).logger = (io.datawire.quark.runtime.Logger) (value);
        }
        if ((name)==("services") || ((Object)(name) != null && ((Object) (name)).equals("services"))) {
            (this).services = (java.util.HashMap<String,Cluster>) (value);
        }
        if ((name)==("started") || ((Object)(name) != null && ((Object) (name)).equals("started"))) {
            (this).started = (Boolean) (value);
        }
        if ((name)==("mutex") || ((Object)(name) != null && ((Object) (name)).equals("mutex"))) {
            (this).mutex = (io.datawire.quark.runtime.Lock) (value);
        }
        if ((name)==("runtime") || ((Object)(name) != null && ((Object) (name)).equals("runtime"))) {
            (this).runtime = (mdk_runtime.MDKRuntime) (value);
        }
        if ((name)==("_fpfactory") || ((Object)(name) != null && ((Object) (name)).equals("_fpfactory"))) {
            (this)._fpfactory = (FailurePolicyFactory) (value);
        }
    }
}
