/* Quark 1.0.452 run at 2016-10-24 14:33:24.783025 */
package mdk_discovery;

/**
 * A Cluster is a group of providers of (possibly different versions of)
 * a single service. Each service provider is represented by a Node.
 */
public class Cluster implements io.datawire.quark.runtime.QObject {
    public static quark.reflect.Class quark_List_mdk_discovery__Request__ref = datawire_mdk_md.Root.quark_List_mdk_discovery__Request__md;
    public static quark.reflect.Class quark_Map_quark_String_mdk_discovery_FailurePolicy__ref = datawire_mdk_md.Root.quark_Map_quark_String_mdk_discovery_FailurePolicy__md;
    public static quark.reflect.Class mdk_discovery_Cluster_ref = datawire_mdk_md.Root.mdk_discovery_Cluster_md;
    public java.util.ArrayList<Node> nodes = new java.util.ArrayList(java.util.Arrays.asList(new Object[]{}));
    public java.util.ArrayList<_Request> _waiting = new java.util.ArrayList(java.util.Arrays.asList(new Object[]{}));
    public java.util.HashMap<String,FailurePolicy> _failurepolicies = io.datawire.quark.runtime.Builtins.map(new Object[]{});
    public Integer _counter = 0;
    public FailurePolicyFactory _fpfactory;
    public Cluster(FailurePolicyFactory fpfactory) {
        (this)._fpfactory = fpfactory;
    }
    /**
     * Choose a single Node to talk to. At present this is a simple round
     * robin.
     */
    public Node choose() {
        return this.chooseVersion(null);
    }
    /**
     * Create a Node for external use.
     */
    public Node _copyNode(Node node) {
        Node result = new Node();
        (result).address = (node).address;
        (result).version = (node).version;
        (result).service = (node).service;
        (result).properties = (node).properties;
        (result)._policy = (this).failurePolicy(node);
        return result;
    }
    /**
     * Get the FailurePolicy for a Node.
     */
    public FailurePolicy failurePolicy(Node node) {
        return ((this)._failurepolicies).get((node).address);
    }
    /**
     * Choose a compatible version of a service to talk to.
     */
    public Node chooseVersion(String version) {
        if (((this.nodes).size())==(0) || ((Object)((this.nodes).size()) != null && ((Object) ((this.nodes).size())).equals(0))) {
            return (Node) (null);
        }
        Integer start = io.datawire.quark.runtime.Builtins.modulo((this._counter), ((this.nodes).size()));
        this._counter = (this._counter) + (1);
        Integer count = 0;
        while ((count) < ((this.nodes).size())) {
            Integer choice = io.datawire.quark.runtime.Builtins.modulo(((start) + (count)), ((this.nodes).size()));
            Node candidate = (this.nodes).get(choice);
            FailurePolicy policy = ((this)._failurepolicies).get((candidate).address);
            if ((mdk_util.Functions.versionMatch(version, (candidate).version)) && ((policy).available())) {
                return (this)._copyNode(candidate);
            }
            count = (count) + (1);
        }
        return (Node) (null);
    }
    /**
     * Add a Node to the cluster (or, if it's already present in the cluster,
     * update its properties).  At present, this involves a linear search, so
     * very large Clusters are unlikely to perform well.
     */
    public void add(Node node) {
        if (!((this._failurepolicies).containsKey((node).address))) {
            (this._failurepolicies).put(((node).address), (((this)._fpfactory).create()));
        }
        if ((((this)._waiting).size()) > (0)) {
            java.util.ArrayList<_Request> waiting = (this)._waiting;
            (this)._waiting = new java.util.ArrayList(java.util.Arrays.asList(new Object[]{}));
            Integer jdx = 0;
            while ((jdx) < ((waiting).size())) {
                _Request req = (waiting).get(jdx);
                if (mdk_util.Functions.versionMatch((req).version, (node).version)) {
                    ((req).factory).resolve((this)._copyNode(node));
                } else {
                    ((this)._waiting).add(req);
                }
                jdx = (jdx) + (1);
            }
        }
        Integer idx = 0;
        while ((idx) < ((this.nodes).size())) {
            if ((((this.nodes).get(idx)).address)==((node).address) || ((Object)(((this.nodes).get(idx)).address) != null && ((Object) (((this.nodes).get(idx)).address)).equals((node).address))) {
                (this.nodes).set((idx), (node));
                return;
            }
            idx = (idx) + (1);
        }
        (this.nodes).add(node);
    }
    public void _addRequest(String version, mdk_runtime.promise.PromiseResolver factory) {
        (this._waiting).add(new _Request(version, factory));
    }
    /**
     * Remove a Node from the cluster, if it's present. If it's not present, do
     * nothing. Note that it is possible to remove all the Nodes and be left with
     * an empty cluster.
     */
    public void remove(Node node) {
        Integer idx = 0;
        while ((idx) < ((this.nodes).size())) {
            Node ep = (this.nodes).get(idx);
            if ((((ep).address)==(null) || ((Object)((ep).address) != null && ((Object) ((ep).address)).equals(null))) || (((ep).address)==((node).address) || ((Object)((ep).address) != null && ((Object) ((ep).address)).equals((node).address)))) {
                (this.nodes).remove((int)(idx));
                return;
            }
            idx = (idx) + (1);
        }
    }
    /**
     * Returns true if and only if this Cluster contains no Nodes.
     */
    public Boolean isEmpty() {
        return ((this.nodes).size()) <= (0);
    }
    /**
     * Return a string representation of the Cluster.
     *
     * WARNING: every Node is represented in the string. Large Clusters will
     * produce unusably large strings.
     */
    public String toString() {
        String result = "Cluster(";
        Integer idx = 0;
        while ((idx) < ((this.nodes).size())) {
            if ((idx) > (0)) {
                result = (result) + (", ");
            }
            result = (result) + (((this.nodes).get(idx)).toString());
            idx = (idx) + (1);
        }
        result = (result) + (")");
        return result;
    }
    public String _getClass() {
        return "mdk_discovery.Cluster";
    }
    public Object _getField(String name) {
        if ((name)==("nodes") || ((Object)(name) != null && ((Object) (name)).equals("nodes"))) {
            return (this).nodes;
        }
        if ((name)==("_waiting") || ((Object)(name) != null && ((Object) (name)).equals("_waiting"))) {
            return (this)._waiting;
        }
        if ((name)==("_failurepolicies") || ((Object)(name) != null && ((Object) (name)).equals("_failurepolicies"))) {
            return (this)._failurepolicies;
        }
        if ((name)==("_counter") || ((Object)(name) != null && ((Object) (name)).equals("_counter"))) {
            return (this)._counter;
        }
        if ((name)==("_fpfactory") || ((Object)(name) != null && ((Object) (name)).equals("_fpfactory"))) {
            return (this)._fpfactory;
        }
        return null;
    }
    public void _setField(String name, Object value) {
        if ((name)==("nodes") || ((Object)(name) != null && ((Object) (name)).equals("nodes"))) {
            (this).nodes = (java.util.ArrayList<Node>) (value);
        }
        if ((name)==("_waiting") || ((Object)(name) != null && ((Object) (name)).equals("_waiting"))) {
            (this)._waiting = (java.util.ArrayList<_Request>) (value);
        }
        if ((name)==("_failurepolicies") || ((Object)(name) != null && ((Object) (name)).equals("_failurepolicies"))) {
            (this)._failurepolicies = (java.util.HashMap<String,FailurePolicy>) (value);
        }
        if ((name)==("_counter") || ((Object)(name) != null && ((Object) (name)).equals("_counter"))) {
            (this)._counter = (Integer) (value);
        }
        if ((name)==("_fpfactory") || ((Object)(name) != null && ((Object) (name)).equals("_fpfactory"))) {
            (this)._fpfactory = (FailurePolicyFactory) (value);
        }
    }
}
