/* Quark 1.0.452 run at 2016-10-24 14:33:24.783025 */
package mdk_discovery;

/**
 * Default circuit breaker policy.
 */
public class CircuitBreaker implements FailurePolicy, io.datawire.quark.runtime.QObject {
    public static quark.reflect.Class mdk_discovery_CircuitBreaker_ref = datawire_mdk_md.Root.mdk_discovery_CircuitBreaker_md;
    public io.datawire.quark.runtime.Logger _log = quark.Functions._getLogger("mdk.breaker");
    public Integer _threshold;
    public Double _delay;
    public mdk_runtime.Time _time;
    public io.datawire.quark.runtime.Lock _mutex = new io.datawire.quark.runtime.Lock();
    public Boolean _failed = false;
    public Integer _failures = 0;
    public Double _lastFailure = 0.0;
    public CircuitBreaker(mdk_runtime.Time time, Integer threshold, Double retestDelay) {
        this._threshold = threshold;
        this._delay = retestDelay;
        this._time = time;
    }
    public void success() {
        (this._mutex).acquire();
        this._failed = false;
        this._failures = 0;
        this._lastFailure = 0.0;
        (this._mutex).release();
    }
    public void failure() {
        (this._mutex).acquire();
        this._failures = (this._failures) + (1);
        this._lastFailure = (this._time).time();
        if ((!((this._threshold)==(0) || ((Object)(this._threshold) != null && ((Object) (this._threshold)).equals(0)))) && ((this._failures) >= (this._threshold))) {
            (this._log).info("BREAKER TRIPPED.");
            this._failed = true;
        }
        (this._mutex).release();
    }
    public Boolean available() {
        if (this._failed) {
            (this._mutex).acquire();
            Boolean result = (((this._time).time()) - (this._lastFailure)) > (this._delay);
            (this._mutex).release();
            if (result) {
                (this._log).info("BREAKER RETEST.");
            }
            return result;
        } else {
            return true;
        }
    }
    public String _getClass() {
        return "mdk_discovery.CircuitBreaker";
    }
    public Object _getField(String name) {
        if ((name)==("_log") || ((Object)(name) != null && ((Object) (name)).equals("_log"))) {
            return (this)._log;
        }
        if ((name)==("_threshold") || ((Object)(name) != null && ((Object) (name)).equals("_threshold"))) {
            return (this)._threshold;
        }
        if ((name)==("_delay") || ((Object)(name) != null && ((Object) (name)).equals("_delay"))) {
            return (this)._delay;
        }
        if ((name)==("_time") || ((Object)(name) != null && ((Object) (name)).equals("_time"))) {
            return (this)._time;
        }
        if ((name)==("_mutex") || ((Object)(name) != null && ((Object) (name)).equals("_mutex"))) {
            return (this)._mutex;
        }
        if ((name)==("_failed") || ((Object)(name) != null && ((Object) (name)).equals("_failed"))) {
            return (this)._failed;
        }
        if ((name)==("_failures") || ((Object)(name) != null && ((Object) (name)).equals("_failures"))) {
            return (this)._failures;
        }
        if ((name)==("_lastFailure") || ((Object)(name) != null && ((Object) (name)).equals("_lastFailure"))) {
            return (this)._lastFailure;
        }
        return null;
    }
    public void _setField(String name, Object value) {
        if ((name)==("_log") || ((Object)(name) != null && ((Object) (name)).equals("_log"))) {
            (this)._log = (io.datawire.quark.runtime.Logger) (value);
        }
        if ((name)==("_threshold") || ((Object)(name) != null && ((Object) (name)).equals("_threshold"))) {
            (this)._threshold = (Integer) (value);
        }
        if ((name)==("_delay") || ((Object)(name) != null && ((Object) (name)).equals("_delay"))) {
            (this)._delay = (Double) (value);
        }
        if ((name)==("_time") || ((Object)(name) != null && ((Object) (name)).equals("_time"))) {
            (this)._time = (mdk_runtime.Time) (value);
        }
        if ((name)==("_mutex") || ((Object)(name) != null && ((Object) (name)).equals("_mutex"))) {
            (this)._mutex = (io.datawire.quark.runtime.Lock) (value);
        }
        if ((name)==("_failed") || ((Object)(name) != null && ((Object) (name)).equals("_failed"))) {
            (this)._failed = (Boolean) (value);
        }
        if ((name)==("_failures") || ((Object)(name) != null && ((Object) (name)).equals("_failures"))) {
            (this)._failures = (Integer) (value);
        }
        if ((name)==("_lastFailure") || ((Object)(name) != null && ((Object) (name)).equals("_lastFailure"))) {
            (this)._lastFailure = (Double) (value);
        }
    }
}
