/* Quark 1.0.452 run at 2016-10-24 14:33:24.783025 */
package mdk;

public class MDKImpl implements MDK, io.datawire.quark.runtime.QObject {
    public static quark.reflect.Class mdk_MDKImpl_ref = datawire_mdk_md.Root.mdk_MDKImpl_md;
    public static quark.reflect.Class quark_Map_quark_String_quark_Object__ref = datawire_mdk_md.Root.quark_Map_quark_String_quark_Object__md;
    /**
     * This header is used to propogate shared context for distributed traces.
     */
    public static String CONTEXT_HEADER = "X-MDK-Context";
    public io.datawire.quark.runtime.Logger logger = quark.Functions._getLogger("mdk");
    public java.util.HashMap<String,Object> _reflection_hack = null;
    public mdk_runtime.MDKRuntime _runtime;
    public mdk_protocol.WSClient _wsclient;
    public mdk_protocol.OpenCloseSubscriber _openclose;
    public mdk_discovery.Discovery _disco;
    public mdk_discovery.DiscoverySource _discoSource;
    public mdk_tracing.Tracer _tracer = null;
    public String procUUID = (quark.concurrent.Context.runtime()).uuid();
    public Boolean _running = false;
    public Double _defaultTimeout = null;
    public MDKImpl(mdk_runtime.MDKRuntime runtime) {
        this._reflection_hack = new java.util.HashMap<String,Object>();
        this._runtime = runtime;
        if (!(((runtime).dependencies).hasService("failurepolicy_factory"))) {
            ((runtime).dependencies).registerService("failurepolicy_factory", this.getFailurePolicy(runtime));
        }
        this._disco = new mdk_discovery.Discovery(runtime);
        this._wsclient = this.getWSClient(runtime);
        if (!((this._wsclient)==(null) || ((Object)(this._wsclient) != null && ((Object) (this._wsclient)).equals(null)))) {
            this._openclose = new mdk_protocol.OpenCloseSubscriber(this._wsclient);
        }
        mdk_runtime.EnvironmentVariables env = (runtime).getEnvVarsService();
        mdk_discovery.DiscoverySourceFactory discoFactory = this.getDiscoveryFactory(env);
        this._discoSource = (discoFactory).create(this._disco, runtime);
        if ((discoFactory).isRegistrar()) {
            ((runtime).dependencies).registerService("discovery_registrar", this._discoSource);
        }
        if (!((this._wsclient)==(null) || ((Object)(this._wsclient) != null && ((Object) (this._wsclient)).equals(null)))) {
            this._tracer = new mdk_tracing.Tracer(runtime, this._wsclient);
            (this._tracer).initContext();
        }
    }
    /**
     * Choose DiscoverySource based on environment variables.
     */
    public mdk_discovery.DiscoverySourceFactory getDiscoveryFactory(mdk_runtime.EnvironmentVariables env) {
        String config = ((env).var("MDK_DISCOVERY_SOURCE")).orElseGet("");
        if ((config)==("") || ((Object)(config) != null && ((Object) (config)).equals(""))) {
            config = ("datawire:") + (mdk_introspection.DatawireToken.getToken(env));
        }
        mdk_discovery.DiscoverySourceFactory result = (mdk_discovery.DiscoverySourceFactory) (null);
        if (Boolean.valueOf((config).startsWith("datawire:"))) {
            result = new mdk_discovery.protocol.DiscoClientFactory(this._wsclient);
        } else {
            if (Boolean.valueOf((config).startsWith("synapse:path="))) {
                result = new mdk_discovery.synapse.Synapse((config).substring((13), ((config).length())));
            } else {
                if (Boolean.valueOf((config).startsWith("static:nodes="))) {
                    String json = (config).substring((13), ((config).length()));
                    result = mdk_discovery.StaticRoutes.parseJSON(json);
                } else {
                    throw new RuntimeException(("Unknown MDK discovery source: ") + (config));
                }
            }
        }
        return result;
    }
    /**
     * Choose FailurePolicy based on environment variables.
     */
    public mdk_discovery.FailurePolicyFactory getFailurePolicy(mdk_runtime.MDKRuntime runtime) {
        String config = (((runtime).getEnvVarsService()).var("MDK_FAILURE_POLICY")).orElseGet("");
        if ((config)==("recording") || ((Object)(config) != null && ((Object) (config)).equals("recording"))) {
            return new mdk_discovery.RecordingFailurePolicyFactory();
        } else {
            return new mdk_discovery.CircuitBreakerFactory(runtime);
        }
    }
    /**
     * Get a WSClient, unless env variables suggest the user doesn't want one.
     */
    public mdk_protocol.WSClient getWSClient(mdk_runtime.MDKRuntime runtime) {
        mdk_runtime.EnvironmentVariables env = (runtime).getEnvVarsService();
        String token = ((env).var("DATAWIRE_TOKEN")).orElseGet("");
        String disco_config = ((env).var("MDK_DISCOVERY_SOURCE")).orElseGet("");
        if ((token)==("") || ((Object)(token) != null && ((Object) (token)).equals(""))) {
            if (Boolean.valueOf((disco_config).startsWith("datawire:"))) {
                token = (disco_config).substring((9), ((disco_config).length()));
            } else {
                return (mdk_protocol.WSClient) (null);
            }
        }
        mdk_runtime.EnvironmentVariable ddu = (env).var("MDK_SERVER_URL");
        String url = (ddu).orElseGet("wss://mcp.datawire.io/rtp");
        return new mdk_protocol.WSClient(runtime, mdk_rtp.Functions.getRTPParser(), url, token);
    }
    public Double _timeout() {
        return 10.0;
    }
    public void start() {
        (this)._running = true;
        if (!((this._wsclient)==(null) || ((Object)(this._wsclient) != null && ((Object) (this._wsclient)).equals(null)))) {
            ((this._runtime).dispatcher).startActor(this._wsclient);
            ((this._runtime).dispatcher).startActor(this._openclose);
            ((this._runtime).dispatcher).startActor(this._tracer);
        }
        ((this._runtime).dispatcher).startActor(this._disco);
        ((this._runtime).dispatcher).startActor(this._discoSource);
    }
    public void stop() {
        (this)._running = false;
        ((this._runtime).dispatcher).stopActor(this._discoSource);
        ((this._runtime).dispatcher).stopActor(this._disco);
        if (!((this._wsclient)==(null) || ((Object)(this._wsclient) != null && ((Object) (this._wsclient)).equals(null)))) {
            ((this._runtime).dispatcher).stopActor(this._tracer);
            ((this._runtime).dispatcher).stopActor(this._openclose);
            ((this._runtime).dispatcher).stopActor(this._wsclient);
        }
        (this._runtime).stop();
    }
    public void register(String service, String version, String address) {
        mdk_discovery.Node node = new mdk_discovery.Node();
        (node).service = service;
        (node).version = version;
        (node).address = address;
        (node).properties = io.datawire.quark.runtime.Builtins.map(new Object[]{"datawire_nodeId", this.procUUID});
        (this._disco).register(node);
    }
    public void setDefaultDeadline(Double seconds) {
        (this)._defaultTimeout = seconds;
    }
    public void setDefaultTimeout(Double seconds) {
        this.setDefaultDeadline(seconds);
    }
    public Session session() {
        SessionImpl session = new SessionImpl(this, null);
        if (!((this._defaultTimeout)==(null) || ((Object)(this._defaultTimeout) != null && ((Object) (this._defaultTimeout)).equals(null)))) {
            (session).setDeadline(this._defaultTimeout);
        }
        return session;
    }
    public Session derive(String encodedContext) {
        SessionImpl session = (SessionImpl) ((this).session());
        mdk_protocol.SharedContext parent = mdk_protocol.SharedContext.decode(encodedContext);
        ((session)._context).properties = (parent).properties;
        if ((((session)._context).properties).containsKey("timeout")) {
            (((session)._context).properties).remove("timeout");
        }
        (session).info("mdk", ((("This session is derived from trace ") + ((parent).traceId)) + (" ")) + (("" + (((parent).clock).clocks))));
        return session;
    }
    public Session join(String encodedContext) {
        SessionImpl session = new SessionImpl(this, encodedContext);
        if (!((this._defaultTimeout)==(null) || ((Object)(this._defaultTimeout) != null && ((Object) (this._defaultTimeout)).equals(null)))) {
            (session).setDeadline(this._defaultTimeout);
        }
        return session;
    }
    public String _getClass() {
        return "mdk.MDKImpl";
    }
    public Object _getField(String name) {
        if ((name)==("CONTEXT_HEADER") || ((Object)(name) != null && ((Object) (name)).equals("CONTEXT_HEADER"))) {
            return MDK.CONTEXT_HEADER;
        }
        if ((name)==("logger") || ((Object)(name) != null && ((Object) (name)).equals("logger"))) {
            return (this).logger;
        }
        if ((name)==("_reflection_hack") || ((Object)(name) != null && ((Object) (name)).equals("_reflection_hack"))) {
            return (this)._reflection_hack;
        }
        if ((name)==("_runtime") || ((Object)(name) != null && ((Object) (name)).equals("_runtime"))) {
            return (this)._runtime;
        }
        if ((name)==("_wsclient") || ((Object)(name) != null && ((Object) (name)).equals("_wsclient"))) {
            return (this)._wsclient;
        }
        if ((name)==("_openclose") || ((Object)(name) != null && ((Object) (name)).equals("_openclose"))) {
            return (this)._openclose;
        }
        if ((name)==("_disco") || ((Object)(name) != null && ((Object) (name)).equals("_disco"))) {
            return (this)._disco;
        }
        if ((name)==("_discoSource") || ((Object)(name) != null && ((Object) (name)).equals("_discoSource"))) {
            return (this)._discoSource;
        }
        if ((name)==("_tracer") || ((Object)(name) != null && ((Object) (name)).equals("_tracer"))) {
            return (this)._tracer;
        }
        if ((name)==("procUUID") || ((Object)(name) != null && ((Object) (name)).equals("procUUID"))) {
            return (this).procUUID;
        }
        if ((name)==("_running") || ((Object)(name) != null && ((Object) (name)).equals("_running"))) {
            return (this)._running;
        }
        if ((name)==("_defaultTimeout") || ((Object)(name) != null && ((Object) (name)).equals("_defaultTimeout"))) {
            return (this)._defaultTimeout;
        }
        return null;
    }
    public void _setField(String name, Object value) {
        if ((name)==("logger") || ((Object)(name) != null && ((Object) (name)).equals("logger"))) {
            (this).logger = (io.datawire.quark.runtime.Logger) (value);
        }
        if ((name)==("_reflection_hack") || ((Object)(name) != null && ((Object) (name)).equals("_reflection_hack"))) {
            (this)._reflection_hack = (java.util.HashMap<String,Object>) (value);
        }
        if ((name)==("_runtime") || ((Object)(name) != null && ((Object) (name)).equals("_runtime"))) {
            (this)._runtime = (mdk_runtime.MDKRuntime) (value);
        }
        if ((name)==("_wsclient") || ((Object)(name) != null && ((Object) (name)).equals("_wsclient"))) {
            (this)._wsclient = (mdk_protocol.WSClient) (value);
        }
        if ((name)==("_openclose") || ((Object)(name) != null && ((Object) (name)).equals("_openclose"))) {
            (this)._openclose = (mdk_protocol.OpenCloseSubscriber) (value);
        }
        if ((name)==("_disco") || ((Object)(name) != null && ((Object) (name)).equals("_disco"))) {
            (this)._disco = (mdk_discovery.Discovery) (value);
        }
        if ((name)==("_discoSource") || ((Object)(name) != null && ((Object) (name)).equals("_discoSource"))) {
            (this)._discoSource = (mdk_discovery.DiscoverySource) (value);
        }
        if ((name)==("_tracer") || ((Object)(name) != null && ((Object) (name)).equals("_tracer"))) {
            (this)._tracer = (mdk_tracing.Tracer) (value);
        }
        if ((name)==("procUUID") || ((Object)(name) != null && ((Object) (name)).equals("procUUID"))) {
            (this).procUUID = (String) (value);
        }
        if ((name)==("_running") || ((Object)(name) != null && ((Object) (name)).equals("_running"))) {
            (this)._running = (Boolean) (value);
        }
        if ((name)==("_defaultTimeout") || ((Object)(name) != null && ((Object) (name)).equals("_defaultTimeout"))) {
            (this)._defaultTimeout = (Double) (value);
        }
    }
}
