/* Quark 1.0.452 run at 2016-10-24 14:33:24.783025 */
package mdk;

/**
 * The MDK API consists of two interfaces: MDK and Session. The
 * MDK interface holds globally scoped APIs and state associated
 * with the microservice. The Session interface holds locally
 * scoped APIs and state. A Session must be used sequentially.
 *
 * The MDK instance is responsible for communicating with
 * foundational services like discovery and tracing.
 *
 * There will typically be one MDK instance for the entire
 * process, and one instance of the Session object per
 * thread/channel/request depending on how the MDK is integrated
 * and used within the application framework of choice.
 *
 * A note on versions: service versions indicate API compatibility, not
 * releases of the underlying code. They should be in the form
 * MAJOR.MINOR, e.g. '2.11'. Major versions indicates
 * incompatibility: '1.0' is incompatible with '2.11'. Minor versions
 * indicate backwards compatibility with new features: a client that wants
 * version '1.1' can talk to version '1.1' and '1.2' but not to version
 * '1.0'.
 *
 */
public interface MDK {
    /**
     * This header is used to propogate shared context for distributed traces.
     */
    public static String CONTEXT_HEADER = "X-MDK-Context";
    public static quark.reflect.Class mdk_MDK_ref = datawire_mdk_md.Root.mdk_MDK_md;
    /**
     * Start the MDK. An MDK instance will not communicate with
     * foundational services unless it is started.
     *
     */
     void start();
    /**
     * Stop the MDK. When the MDK stops unregisters any service
     * endpoints from the discovery system. This should always
     * be done prior to process exit in order to propogate node
     * shutdowns in realtime rather than waiting for heartbeats
     * to detect node departures.
     *
     */
     void stop();
    /**
     * Registers a service endpoint with the discovery
     * system. This can be called at any point, however
     * registered endpoints will not be advertised to the
     * discovery system until the MDK is started.
     *
     */
     void register(String service, String version, String address);
    /**
     * Set the default timeout for MDK sessions.
     *
     * This is the maximum timeout; if a joined session has a lower
     * timeout that will be used.
     *
     */
     void setDefaultDeadline(Double seconds);
    /**
     * DEPRECATED, use setDefaultDeadline().
     */
     void setDefaultTimeout(Double seconds);
    /**
     * Creates a new Session. A Session created in this way will
     * result in a new distributed trace. This should therefore
     * be used primarily by edge services. Intermediary and
     * foundational services should make use of
     * join(encodedContext) in order to preserve distributed
     * traces.
     *
     */
     Session session();
    /**
     * Create a new Session and join it to an existing distributed sesion.
     *
     * This should only ever be done once per an encoded context. That
     * means you should only use it for RPC or similar one-off calls. If
     * you received the encoded context via a broadcast medium (pub/sub,
     * message queues with multiple readers, etc.) you should use
     * childSession() instead.
     *
     */
     Session join(String encodedContext);
    /**
     * Create a new Session. The given encoded distributed session's
     * properties will be used to configure the new Session,
     * e.g. overrides will be preserved. However, because this is a new
     * Session the timeout will not be copied from the encoded session.
     *
     * This is intended for use for encoded context received via a
     * broadcast medium (pub/sub, message queues with multiple readers,
     * etc.). If you know only you received the encoded context,
     * e.g. you're coding a server that receives the context from a HTTP
     * request, you should join() instead.
     *
     */
     Session derive(String encodedContext);
}
