/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.TableRow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class DataTable {
    private final Location location;
    private final List<TableRow> rows;

    public DataTable(Location location, List<TableRow> rows) {
        this.location = Objects.requireNonNull(location, "DataTable.location cannot be null");
        this.rows = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(rows, "DataTable.rows cannot be null")));
    }

    public Location getLocation() {
        return this.location;
    }

    public List<TableRow> getRows() {
        return this.rows;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataTable that = (DataTable)o;
        return this.location.equals(that.location) && this.rows.equals(that.rows);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.rows);
    }

    public String toString() {
        return "DataTable{location=" + this.location + ", rows=" + this.rows + '}';
    }
}

