/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.gherkin.Gherkin;
import io.cucumber.gherkin.IO;
import io.cucumber.gherkin.ProtobufGherkinMessages;
import io.cucumber.messages.Messages;
import io.cucumber.messages.com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Main {
    public static void main(String[] argv) throws IOException, InterruptedException {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(argv));
        ArrayList<String> paths = new ArrayList<String>();
        boolean includeSource = true;
        boolean includeAst = true;
        boolean includePickles = true;
        JsonFormat.Printer jsonPrinter = null;
        boolean dialects = false;
        block14: while (!args.isEmpty()) {
            String arg;
            switch (arg = ((String)args.remove(0)).trim()) {
                case "--no-source": {
                    includeSource = false;
                    continue block14;
                }
                case "--no-ast": {
                    includeAst = false;
                    continue block14;
                }
                case "--no-pickles": {
                    includePickles = false;
                    continue block14;
                }
                case "--json": {
                    jsonPrinter = JsonFormat.printer();
                    continue block14;
                }
                case "--dialects": {
                    dialects = true;
                    continue block14;
                }
            }
            paths.add(arg);
        }
        if (dialects) {
            InputStream gherkinStdout = Gherkin.EXE.execute(Collections.singletonList("--dialects"), null);
            IO.copy(gherkinStdout, System.out);
            System.exit(0);
        }
        List<Messages.Wrapper> messages = paths.isEmpty() ? new ProtobufGherkinMessages(System.in).messages() : Gherkin.fromPaths(paths, includeSource, includeAst, includePickles);
        Main.printMessages(jsonPrinter, messages);
    }

    private static void printMessages(JsonFormat.Printer jsonPrinter, List<Messages.Wrapper> messages) throws IOException {
        for (Messages.Wrapper wrapper : messages) {
            if (jsonPrinter != null) {
                IO.out.write(jsonPrinter.print(wrapper));
                IO.out.write("\n");
                IO.out.flush();
                continue;
            }
            wrapper.writeDelimitedTo(System.out);
        }
    }
}

