/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.plugin.event;

import io.cucumber.plugin.event.Location;
import io.cucumber.plugin.event.TimeStampedEvent;
import java.net.URI;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class SnippetsSuggestedEvent
extends TimeStampedEvent {
    private final URI uri;
    private final Location scenarioLocation;
    private final Location stepLocation;
    private final List<String> snippets;

    @Deprecated
    public SnippetsSuggestedEvent(Instant timeInstant, URI uri, int scenarioLine, int stepLine, List<String> snippets) {
        this(timeInstant, uri, new Location(scenarioLine, -1), new Location(stepLine, -1), snippets);
    }

    public SnippetsSuggestedEvent(Instant instant, URI uri, Location scenarioLocation, Location stepLocation, List<String> snippets) {
        super(instant);
        this.uri = Objects.requireNonNull(uri);
        this.scenarioLocation = scenarioLocation;
        this.stepLocation = stepLocation;
        this.snippets = Collections.unmodifiableList(Objects.requireNonNull(snippets));
    }

    public URI getUri() {
        return this.uri;
    }

    @Deprecated
    public int getStepLine() {
        return this.stepLocation.getLine();
    }

    @Deprecated
    public int getScenarioLine() {
        return this.scenarioLocation.getLine();
    }

    public Location getScenarioLocation() {
        return this.scenarioLocation;
    }

    public Location getStepLocation() {
        return this.stepLocation;
    }

    public List<String> getSnippets() {
        return this.snippets;
    }
}

