/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin;

import io.cucumber.core.gherkin.Container;
import io.cucumber.core.gherkin.Example;
import io.cucumber.core.gherkin.Examples;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.Located;
import io.cucumber.core.gherkin.Named;
import io.cucumber.core.gherkin.Rule;
import io.cucumber.core.gherkin.Scenario;
import io.cucumber.core.gherkin.ScenarioOutline;
import java.util.function.BiFunction;

public interface Node
extends Located,
Named {
    default public <T> T map(T parent, BiFunction<Feature, T, T> mapFeature, BiFunction<Scenario, T, T> mapScenario, BiFunction<Rule, T, T> mapRule, BiFunction<ScenarioOutline, T, T> mapScenarioOutline, BiFunction<Examples, T, T> mapExamples, BiFunction<Example, T, T> mapExample) {
        if (this instanceof Scenario) {
            return mapScenario.apply((Scenario)this, (Scenario)parent);
        }
        if (this instanceof Example) {
            return mapExample.apply((Example)this, (Example)parent);
        }
        if (this instanceof Container) {
            Object mapped;
            if (this instanceof Feature) {
                mapped = mapFeature.apply((Feature)this, (Feature)parent);
            } else if (this instanceof Rule) {
                mapped = mapRule.apply((Rule)this, (Rule)parent);
            } else if (this instanceof ScenarioOutline) {
                mapped = mapScenarioOutline.apply((ScenarioOutline)this, (ScenarioOutline)parent);
            } else if (this instanceof Examples) {
                mapped = mapExamples.apply((Examples)this, (Examples)parent);
            } else {
                throw new IllegalArgumentException(this.getClass().getName());
            }
            Container container = (Container)((Object)this);
            container.children().forEach(node -> node.map(mapped, mapFeature, mapScenario, mapRule, mapScenarioOutline, mapExamples, mapExample));
            return mapped;
        }
        throw new IllegalArgumentException(this.getClass().getName());
    }
}

