/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.feature.FeatureWithLines;
import io.cucumber.core.plugin.UTF8PrintWriter;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestRunFinished;
import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public final class RerunFormatter
implements ConcurrentEventListener {
    private final UTF8PrintWriter out;
    private final Map<URI, Collection<Integer>> featureAndFailedLinesMapping = new LinkedHashMap<URI, Collection<Integer>>();

    public RerunFormatter(OutputStream out) {
        this.out = new UTF8PrintWriter(out);
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestCaseFinished.class, this::handleTestCaseFinished);
        publisher.registerHandlerFor(TestRunFinished.class, event -> this.finishReport());
    }

    private void handleTestCaseFinished(TestCaseFinished event) {
        if (!event.getResult().getStatus().isOk()) {
            this.recordTestFailed(event.getTestCase());
        }
    }

    private void finishReport() {
        for (Map.Entry<URI, Collection<Integer>> entry : this.featureAndFailedLinesMapping.entrySet()) {
            FeatureWithLines featureWithLines = FeatureWithLines.create(RerunFormatter.relativize(entry.getKey()), entry.getValue());
            this.out.println(featureWithLines.toString());
        }
        this.out.close();
    }

    private void recordTestFailed(TestCase testCase) {
        URI uri = testCase.getUri();
        Collection<Integer> failedTestCaseLines = this.getFailedTestCaseLines(uri);
        failedTestCaseLines.add(testCase.getLocation().getLine());
    }

    private Collection<Integer> getFailedTestCaseLines(URI uri) {
        return this.featureAndFailedLinesMapping.computeIfAbsent(uri, k -> new ArrayList());
    }

    static URI relativize(URI uri) {
        if (!"file".equals(uri.getScheme())) {
            return uri;
        }
        if (!uri.isAbsolute()) {
            return uri;
        }
        try {
            URI root = new File("").toURI();
            URI relative = root.relativize(uri);
            return new URI("file", relative.getSchemeSpecificPart(), relative.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }
}

