/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.stepexpression;

import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.stepexpression.DocStringTransformer;
import io.cucumber.core.stepexpression.RawTableTransformer;
import io.cucumber.core.stepexpression.StepExpression;
import io.cucumber.core.stepexpression.StepTypeRegistry;
import io.cucumber.cucumberexpressions.Expression;
import io.cucumber.cucumberexpressions.ExpressionFactory;
import io.cucumber.cucumberexpressions.UndefinedParameterTypeException;
import io.cucumber.datatable.DataTable;
import io.cucumber.datatable.DataTableTypeRegistryTableConverter;
import io.cucumber.docstring.DocString;
import io.cucumber.docstring.DocStringTypeRegistryDocStringConverter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.function.Supplier;

public final class StepExpressionFactory {
    private final ExpressionFactory expressionFactory;
    private final DataTableTypeRegistryTableConverter tableConverter;
    private final DocStringTypeRegistryDocStringConverter docStringConverter;

    public StepExpressionFactory(StepTypeRegistry registry) {
        this.expressionFactory = new ExpressionFactory(registry.parameterTypeRegistry());
        this.tableConverter = new DataTableTypeRegistryTableConverter(registry.dataTableTypeRegistry());
        this.docStringConverter = new DocStringTypeRegistryDocStringConverter(registry.docStringTypeRegistry());
    }

    public StepExpression createExpression(String expressionString) {
        if (expressionString == null) {
            throw new NullPointerException("expression can not be null");
        }
        Expression expression = this.expressionFactory.createExpression(expressionString);
        RawTableTransformer<DataTable> toDataTable = raw -> DataTable.create((List)raw, (DataTable.TableConverter)this.tableConverter);
        DocStringTransformer<Object> toDocString = (input, contentType) -> input;
        return new StepExpression(expression, toDocString, toDataTable);
    }

    public StepExpression createExpression(String expressionString, Type tableOrDocStringType) {
        return this.createExpression(expressionString, () -> tableOrDocStringType, false);
    }

    public StepExpression createExpression(String expressionString, Supplier<Type> tableOrDocStringType) {
        return this.createExpression(expressionString, tableOrDocStringType, false);
    }

    public StepExpression createExpression(String expressionString, Type tableOrDocStringType, boolean transpose) {
        return this.createExpression(expressionString, () -> tableOrDocStringType, transpose);
    }

    public StepExpression createExpression(String expressionString, Supplier<Type> tableOrDocStringType, boolean transpose) {
        Expression expression;
        if (expressionString == null) {
            throw new NullPointerException("expressionString can not be null");
        }
        if (tableOrDocStringType == null) {
            throw new NullPointerException("tableOrDocStringType can not be null");
        }
        try {
            expression = this.expressionFactory.createExpression(expressionString);
        }
        catch (UndefinedParameterTypeException e) {
            throw this.registerTypeInConfiguration(expressionString, e);
        }
        RawTableTransformer<Object> tableTransform = raw -> {
            DataTable dataTable = DataTable.create((List)raw, (DataTable.TableConverter)this.tableConverter);
            Type targetType = (Type)tableOrDocStringType.get();
            return dataTable.convert((Type)(Object.class.equals((Object)targetType) ? DataTable.class : targetType), transpose);
        };
        DocStringTransformer<Object> docStringTransform = (text, contentType) -> {
            DocString docString = DocString.create((String)text, (String)contentType, (DocString.DocStringConverter)this.docStringConverter);
            Type targetType = (Type)tableOrDocStringType.get();
            return docString.convert((Type)(Object.class.equals((Object)targetType) ? DocString.class : targetType));
        };
        return new StepExpression(expression, docStringTransform, tableTransform);
    }

    private CucumberException registerTypeInConfiguration(String expressionString, UndefinedParameterTypeException e) {
        return new CucumberException(String.format("Could not create a cucumber expression for '%s'.\nIt appears you did not register parameter type. The details are in the stacktrace below.\nYou can find the documentation here: https://docs.cucumber.io/cucumber/cucumber-expressions/", expressionString), e);
    }
}

