/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.snippets;

import io.cucumber.core.snippets.Joiner;

final class FunctionNameGenerator {
    private static final Character SUBST = Character.valueOf(' ');
    private final Joiner joiner;

    FunctionNameGenerator(Joiner joiner) {
        this.joiner = joiner;
    }

    String generateFunctionName(String sentence) {
        sentence = this.removeIllegalCharacters(sentence);
        sentence = sentence.trim();
        String[] words = sentence.split("\\s");
        return this.joiner.concatenate(words);
    }

    private String removeIllegalCharacters(String sentence) {
        if (sentence.isEmpty()) {
            throw new IllegalArgumentException("Cannot create function name from empty sentence");
        }
        StringBuilder sanitized = new StringBuilder();
        sanitized.append(Character.isJavaIdentifierStart(sentence.charAt(0)) ? sentence.charAt(0) : SUBST.charValue());
        for (int i = 1; i < sentence.length(); ++i) {
            if (Character.isJavaIdentifierPart(sentence.charAt(i))) {
                sanitized.append(sentence.charAt(i));
                continue;
            }
            if (sanitized.charAt(sanitized.length() - 1) == SUBST.charValue() || i == sentence.length() - 1) continue;
            sanitized.append(SUBST);
        }
        return sanitized.toString();
    }
}

