/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runner;

import io.cucumber.core.backend.CucumberBackendException;
import io.cucumber.core.backend.CucumberInvocationTargetException;
import io.cucumber.core.backend.ParameterInfo;
import io.cucumber.core.backend.StepDefinition;
import io.cucumber.core.backend.TestCaseState;
import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.gherkin.Step;
import io.cucumber.core.runner.Match;
import io.cucumber.core.runner.StackManipulation;
import io.cucumber.core.runner.StepDefinitionMatch;
import io.cucumber.core.stepexpression.Argument;
import io.cucumber.cucumberexpressions.CucumberExpressionException;
import io.cucumber.datatable.CucumberDataTableException;
import io.cucumber.datatable.UndefinedDataTableTypeException;
import io.cucumber.docstring.CucumberDocStringException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

class PickleStepDefinitionMatch
extends Match
implements StepDefinitionMatch {
    private final StepDefinition stepDefinition;
    private final URI uri;
    private final Step step;

    PickleStepDefinitionMatch(List<Argument> arguments, StepDefinition stepDefinition, URI uri, Step step) {
        super(arguments, stepDefinition.getLocation());
        this.stepDefinition = stepDefinition;
        this.uri = uri;
        this.step = step;
    }

    @Override
    public void runStep(TestCaseState state) throws Throwable {
        List<Argument> arguments = this.getArguments();
        List<ParameterInfo> parameterInfos = this.stepDefinition.parameterInfos();
        if (parameterInfos != null && arguments.size() != parameterInfos.size()) {
            throw this.arityMismatch(parameterInfos.size());
        }
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            for (Argument argument : arguments) {
                result.add(argument.getValue());
            }
        }
        catch (UndefinedDataTableTypeException e) {
            throw this.registerDataTableTypeInConfiguration((Exception)((Object)e));
        }
        catch (CucumberExpressionException | CucumberDataTableException | CucumberDocStringException e) {
            CucumberInvocationTargetException targetException = this.causedByCucumberInvocationTargetException((RuntimeException)e);
            if (targetException != null) {
                throw StackManipulation.removeFrameworkFrames(targetException);
            }
            throw this.couldNotConvertArguments((Exception)e);
        }
        catch (CucumberBackendException e) {
            throw this.couldNotInvokeArgumentConversion(e);
        }
        catch (CucumberInvocationTargetException e) {
            throw StackManipulation.removeFrameworkFrames(e);
        }
        try {
            this.stepDefinition.execute(result.toArray(new Object[0]));
        }
        catch (CucumberBackendException e) {
            throw this.couldNotInvokeStep(e, result);
        }
        catch (CucumberInvocationTargetException e) {
            throw StackManipulation.removeFrameworkFramesAndAppendStepLocation(e, this.getStepLocation());
        }
    }

    private CucumberInvocationTargetException causedByCucumberInvocationTargetException(RuntimeException e) {
        Throwable cause = e.getCause();
        if (cause instanceof CucumberInvocationTargetException) {
            return (CucumberInvocationTargetException)cause;
        }
        return null;
    }

    private Throwable couldNotInvokeStep(CucumberBackendException e, List<Object> result) {
        String argumentTypes = this.createArgumentTypes(result);
        return new CucumberException(String.format("Could not invoke step [%s] defined at '%s'.\nIt appears there was a problem with the step definition.\nThe converted arguments types were (" + argumentTypes + ")\n\nThe details are in the stacktrace below.", this.stepDefinition.getPattern(), this.stepDefinition.getLocation()), e);
    }

    private CucumberException couldNotInvokeArgumentConversion(CucumberBackendException e) {
        return new CucumberException(String.format("Could not convert arguments for step [%s] defined at '%s'.\nIt appears there was a problem with a hook or transformer definition. The details are in the stacktrace below.", this.stepDefinition.getPattern(), this.stepDefinition.getLocation()), e);
    }

    private String createArgumentTypes(List<Object> result) {
        return result.stream().map(o -> o == null ? "null" : o.getClass().getName()).collect(Collectors.joining(", "));
    }

    private CucumberException registerDataTableTypeInConfiguration(Exception e) {
        return new CucumberException(String.format("Could not convert arguments for step [%s] defined at '%s'.\nIt appears you did not register a data table type. The details are in the stacktrace below.", this.stepDefinition.getPattern(), this.stepDefinition.getLocation()), e);
    }

    private CucumberException couldNotConvertArguments(Exception e) {
        return new CucumberException(String.format("Could not convert arguments for step [%s] defined at '%s'.\nThe details are in the stacktrace below.", this.stepDefinition.getPattern(), this.stepDefinition.getLocation()), e);
    }

    @Override
    public void dryRunStep(TestCaseState state) throws Throwable {
    }

    private CucumberException arityMismatch(int parameterCount) {
        List<String> arguments = this.createArgumentsForErrorMessage();
        return new CucumberException(String.format("Step [%s] is defined with %s parameters at '%s'.\nHowever, the gherkin step has %s arguments%sStep text: %s", this.stepDefinition.getPattern(), parameterCount, this.stepDefinition.getLocation(), arguments.size(), this.formatArguments(arguments), this.step.getText()));
    }

    private String formatArguments(List<String> arguments) {
        if (arguments.isEmpty()) {
            return ".\n";
        }
        StringBuilder formatted = new StringBuilder(":\n");
        for (String argument : arguments) {
            formatted.append(" * ").append(argument).append("\n");
        }
        return formatted.toString();
    }

    private List<String> createArgumentsForErrorMessage() {
        ArrayList<String> arguments = new ArrayList<String>(this.getArguments().size());
        for (Argument argument : this.getArguments()) {
            arguments.add(argument.toString());
        }
        return arguments;
    }

    public String getPattern() {
        return this.stepDefinition.getPattern();
    }

    private StackTraceElement getStepLocation() {
        return new StackTraceElement("\u273d", this.step.getText(), this.uri.toString(), this.step.getLine());
    }

    StepDefinition getStepDefinition() {
        return this.stepDefinition;
    }

    @Override
    public String getCodeLocation() {
        return this.stepDefinition.getLocation();
    }
}

