/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.xstream;

import cucumber.deps.com.thoughtworks.xstream.XStream;
import cucumber.deps.com.thoughtworks.xstream.annotations.XStreamConverter;
import cucumber.deps.com.thoughtworks.xstream.converters.Converter;
import cucumber.deps.com.thoughtworks.xstream.converters.ConverterLookup;
import cucumber.deps.com.thoughtworks.xstream.converters.ConverterMatcher;
import cucumber.deps.com.thoughtworks.xstream.converters.ConverterRegistry;
import cucumber.deps.com.thoughtworks.xstream.converters.SingleValueConverter;
import cucumber.deps.com.thoughtworks.xstream.core.DefaultConverterLookup;
import cucumber.runtime.CucumberException;
import cucumber.runtime.ParameterInfo;
import cucumber.runtime.xstream.BigDecimalConverter;
import cucumber.runtime.xstream.BigIntegerConverter;
import cucumber.runtime.xstream.ByteConverter;
import cucumber.runtime.xstream.CalendarConverter;
import cucumber.runtime.xstream.DateConverter;
import cucumber.runtime.xstream.DoubleConverter;
import cucumber.runtime.xstream.DynamicClassBasedSingleValueConverter;
import cucumber.runtime.xstream.DynamicClassWithStringAssignableConverter;
import cucumber.runtime.xstream.DynamicEnumConverter;
import cucumber.runtime.xstream.FloatConverter;
import cucumber.runtime.xstream.IntegerConverter;
import cucumber.runtime.xstream.ListConverter;
import cucumber.runtime.xstream.LongConverter;
import cucumber.runtime.xstream.PatternConverter;
import cucumber.runtime.xstream.SingleValueConverterWrapperExt;
import cucumber.runtime.xstream.TimeConverter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LocalizedXStreams {
    private final Map<Locale, LocalizedXStream> xStreamsByLocale = new HashMap<Locale, LocalizedXStream>();
    private final List<XStreamConverter> extraConverters;
    private final ClassLoader classLoader;

    public LocalizedXStreams(ClassLoader classLoader, List<XStreamConverter> extraConverters) {
        this.classLoader = classLoader;
        this.extraConverters = extraConverters;
    }

    public LocalizedXStreams(ClassLoader classLoader) {
        this(classLoader, Collections.emptyList());
    }

    public LocalizedXStream get(Locale locale) {
        LocalizedXStream xStream = this.xStreamsByLocale.get(locale);
        if (xStream == null) {
            xStream = this.newXStream(locale);
            this.registerExtraConverters(xStream);
            this.xStreamsByLocale.put(locale, xStream);
        }
        return xStream;
    }

    private LocalizedXStream newXStream(Locale locale) {
        DefaultConverterLookup lookup = new DefaultConverterLookup();
        return new LocalizedXStream(this.classLoader, (ConverterLookup)lookup, (ConverterRegistry)lookup, locale);
    }

    private void registerExtraConverters(LocalizedXStream xStream) {
        for (XStreamConverter converter : this.extraConverters) {
            try {
                ConverterMatcher matcher = (ConverterMatcher)converter.value().newInstance();
                if (!(matcher instanceof Converter)) continue;
                xStream.registerConverter((Converter)matcher, converter.priority());
            }
            catch (InstantiationException e) {
                throw new CucumberException(e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new CucumberException(e.getMessage(), e);
            }
        }
    }

    public static class LocalizedXStream
    extends XStream {
        private final Locale locale;
        private final ThreadLocal<List<TimeConverter>> timeConverters = new ThreadLocal<List<TimeConverter>>(){

            @Override
            protected List<TimeConverter> initialValue() {
                return new ArrayList<TimeConverter>();
            }
        };

        public LocalizedXStream(ClassLoader classLoader, ConverterLookup converterLookup, ConverterRegistry converterRegistry, Locale locale) {
            super(null, null, classLoader, null, converterLookup, converterRegistry);
            this.locale = locale;
            this.autodetectAnnotations(true);
            this.register(converterRegistry, new BigDecimalConverter(locale));
            this.register(converterRegistry, new BigIntegerConverter(locale));
            this.register(converterRegistry, new ByteConverter(locale));
            this.register(converterRegistry, new DateConverter(locale));
            this.register(converterRegistry, new CalendarConverter(locale));
            this.register(converterRegistry, new DoubleConverter(locale));
            this.register(converterRegistry, new FloatConverter(locale));
            this.register(converterRegistry, new IntegerConverter(locale));
            this.register(converterRegistry, new LongConverter(locale));
            this.register(converterRegistry, new PatternConverter());
            converterRegistry.registerConverter((Converter)new DynamicEnumConverter(locale), 10000);
            converterRegistry.registerConverter((Converter)new DynamicClassWithStringAssignableConverter(), -10);
        }

        private void register(ConverterRegistry lookup, SingleValueConverter converter) {
            lookup.registerConverter((Converter)new SingleValueConverterWrapperExt(converter), 10000);
        }

        public void setParameterInfo(ParameterInfo parameterInfo) {
            if (parameterInfo != null) {
                List<Class> timeClasses = TimeConverter.getTimeClasses();
                for (Class timeClass : timeClasses) {
                    SingleValueConverterWrapperExt converterWrapper = (SingleValueConverterWrapperExt)this.getConverterLookup().lookupConverterForType(timeClass);
                    TimeConverter timeConverter = (TimeConverter)converterWrapper.getConverter();
                    timeConverter.setParameterInfoAndLocale(parameterInfo, this.locale);
                    this.timeConverters.get().add(timeConverter);
                }
            }
        }

        public void unsetParameterInfo() {
            for (TimeConverter timeConverter : this.timeConverters.get()) {
                timeConverter.removeOnlyFormat();
            }
            this.timeConverters.get().clear();
        }

        public SingleValueConverter getSingleValueConverter(Type type) {
            if (Object.class.equals(type)) {
                type = String.class;
            }
            if (type instanceof Class) {
                Class clazz = (Class)type;
                ConverterLookup converterLookup = this.getConverterLookup();
                Converter converter = converterLookup.lookupConverterForType(clazz);
                if (converter instanceof DynamicClassBasedSingleValueConverter) {
                    return ((DynamicClassBasedSingleValueConverter)converter).converterForClass(clazz);
                }
                return converter instanceof SingleValueConverter ? (SingleValueConverter)converter : null;
            }
            return null;
        }

        public SingleValueConverter createListConverter(String delimiter, SingleValueConverter elementConverter) {
            return new ListConverter(delimiter, elementConverter);
        }

        public Locale getLocale() {
            return this.locale;
        }
    }
}

