/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.xstream;

import cucumber.deps.com.thoughtworks.xstream.annotations.XStreamConverter;
import cucumber.runtime.CucumberException;
import cucumber.runtime.table.CamelCaseStringConverter;
import cucumber.runtime.table.PascalCaseStringConverter;
import cucumber.runtime.xstream.CellWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class ComplexTypeWriter
extends CellWriter {
    private final List<String> columnNames;
    private final Map<String, String> fields = new LinkedHashMap<String, String>();
    private final Stack<String> currentKey = new Stack();

    public ComplexTypeWriter(List<String> columnNames) {
        this.columnNames = columnNames;
    }

    @Override
    public List<String> getHeader() {
        return this.columnNames.isEmpty() ? new ArrayList<String>(this.fields.keySet()) : this.columnNames;
    }

    @Override
    public List<String> getValues() {
        CamelCaseStringConverter converter = new CamelCaseStringConverter();
        if (!this.columnNames.isEmpty()) {
            String[] explicitFieldValues = new String[this.columnNames.size()];
            int n = 0;
            for (String columnName : this.columnNames) {
                String convertedColumnName = converter.map(columnName);
                explicitFieldValues[n] = this.fields.containsKey(convertedColumnName) ? this.fields.get(convertedColumnName) : "";
                ++n;
            }
            return Arrays.asList(explicitFieldValues);
        }
        return new ArrayList<String>(this.fields.values());
    }

    public void startNode(String name) {
        this.currentKey.push(name);
        if (this.currentKey.size() == 2) {
            this.fields.put(name, "");
        }
    }

    public void addAttribute(String name, String value) {
    }

    public void setValue(String value) {
        if (this.currentKey.size() < 2) {
            return;
        }
        if (this.currentKey.size() == 2) {
            this.fields.put(this.currentKey.peek(), value == null ? "" : value);
            return;
        }
        String clazz = (String)this.currentKey.get(0);
        String field = (String)this.currentKey.get(1);
        if (this.columnNames.isEmpty() || this.columnNames.contains(field)) {
            throw ComplexTypeWriter.createMissingConverterException(clazz, field);
        }
    }

    public void endNode() {
        this.currentKey.pop();
    }

    public void flush() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        throw new UnsupportedOperationException();
    }

    private static CucumberException createMissingConverterException(String clazz, String field) {
        PascalCaseStringConverter converter = new PascalCaseStringConverter();
        return new CucumberException(String.format("Don't know how to convert \"%s.%s\" into a table entry.\nEither exclude %s from the table by selecting the fields to include:\n\nDataTable.create(entries, \"Field\", \"Other Field\")\n\nOr try writing your own converter:\n\n@%s(%sConverter.class)\n%s %s;\n", clazz, field, field, XStreamConverter.class.getName(), converter.map(field), ComplexTypeWriter.modifierAndTypeOfField(clazz, field), field));
    }

    private static String modifierAndTypeOfField(String clazz, String fieldName) {
        try {
            Field field = Class.forName(clazz).getDeclaredField(fieldName);
            String simpleTypeName = field.getType().getSimpleName();
            String modifiers = Modifier.toString(field.getModifiers());
            return modifiers + " " + simpleTypeName;
        }
        catch (NoSuchFieldException e) {
            return "private Object";
        }
        catch (ClassNotFoundException e) {
            return "private Object";
        }
    }
}

