/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runner;

import cucumber.api.event.Event;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventPublisher;
import cucumber.runner.TimeService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventBus
implements EventPublisher {
    private final TimeService stopWatch;
    private Map<Class<? extends Event>, List<EventHandler>> handlers = new HashMap<Class<? extends Event>, List<EventHandler>>();

    public EventBus(TimeService stopWatch) {
        this.stopWatch = stopWatch;
    }

    public Long getTime() {
        return this.stopWatch.time();
    }

    public void send(Event event) {
        if (this.handlers.containsKey(event.getClass())) {
            for (EventHandler handler : this.handlers.get(event.getClass())) {
                handler.receive(event);
            }
        }
    }

    @Override
    public <T extends Event> void registerHandlerFor(Class<T> eventType, EventHandler<T> handler) {
        if (this.handlers.containsKey(eventType)) {
            this.handlers.get(eventType).add(handler);
        } else {
            ArrayList<EventHandler<T>> list = new ArrayList<EventHandler<T>>();
            list.add(handler);
            this.handlers.put(eventType, list);
        }
    }
}

