/*
 * Decompiled with CFR 0.152.
 */
package cucumber.api.formatter;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;

public class NiceAppendable {
    private static final CharSequence NL = "\n";
    private final Appendable out;

    public NiceAppendable(Appendable out) {
        this.out = out;
    }

    public NiceAppendable append(CharSequence csq) {
        try {
            this.out.append(csq);
            this.tryFlush();
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public NiceAppendable append(CharSequence csq, int start, int end) {
        try {
            this.out.append(csq, start, end);
            this.tryFlush();
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public NiceAppendable append(char c) {
        try {
            this.out.append(c);
            this.tryFlush();
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public NiceAppendable println() {
        return this.append(NL);
    }

    public NiceAppendable println(CharSequence csq) {
        try {
            StringBuilder buffer = new StringBuilder();
            buffer.append(csq);
            buffer.append(NL);
            this.out.append(buffer.toString());
            this.tryFlush();
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.tryFlush();
            if (this.out instanceof Closeable) {
                ((Closeable)((Object)this.out)).close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void tryFlush() {
        if (!(this.out instanceof Flushable)) {
            return;
        }
        try {
            ((Flushable)((Object)this.out)).flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

