/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.validation;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import io.confluent.rest.exceptions.RestTimeoutException;
import io.confluent.rest.validation.ConstraintViolations;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.TimeoutException;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;

@Provider
public class JacksonMessageBodyProvider
extends JacksonJaxbJsonProvider {
    public JacksonMessageBodyProvider() {
        this.setMapper(new ObjectMapper());
    }

    public JacksonMessageBodyProvider(ObjectMapper mapper) {
        this.setMapper(mapper);
    }

    protected boolean hasMatchingMediaType(MediaType mediaType) {
        return super.hasMatchingMediaType(mediaType) || this.isApplicationOctetStream(mediaType);
    }

    protected boolean isApplicationOctetStream(MediaType mediaType) {
        return mediaType != null && mediaType.getType().equals("application") && mediaType.getSubtype().equals("octet-stream");
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            return super.readFrom(type, genericType, annotations, mediaType, httpHeaders, entityStream);
        }
        catch (UnrecognizedPropertyException e) {
            throw ConstraintViolations.simpleException("Unrecognized field: " + e.getPropertyName());
        }
        catch (JsonMappingException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ConstraintViolationException) {
                throw (ConstraintViolationException)cause;
            }
            throw e;
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            if (cause instanceof TimeoutException) {
                throw new RestTimeoutException("Timeout while reading from inputStream", RestTimeoutException.DEFAULT_ERROR_CODE, RestTimeoutException.DEFAULT_ERROR_CODE, e);
            }
            throw e;
        }
    }
}

