/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.exceptions;

import com.fasterxml.jackson.databind.JsonMappingException;
import io.confluent.rest.entities.ErrorMessage;
import javax.annotation.Priority;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
@Priority(value=1)
public class JsonMappingExceptionMapper
implements ExceptionMapper<JsonMappingException> {
    public static final int BAD_REQUEST_CODE = 400;
    public static final String MESSAGE_SOURCE_SPLITTER = "\\(for Object starting at";

    public Response toResponse(JsonMappingException exception) {
        String originalMessage = exception.getOriginalMessage();
        String messageWithoutSource = originalMessage == null ? null : originalMessage.split(MESSAGE_SOURCE_SPLITTER)[0].trim();
        ErrorMessage message = new ErrorMessage(400, messageWithoutSource);
        return Response.status((int)400).entity((Object)message).build();
    }
}

