/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import io.confluent.ksql.util.ConsistencyOffsetVector;
import io.confluent.ksql.util.KsqlHostInfo;
import io.confluent.ksql.util.PushOffsetRange;
import java.util.Objects;
import java.util.Optional;

public final class RowMetadata {
    private final Optional<PushOffsetRange> pushOffsetsRange;
    private final Optional<ConsistencyOffsetVector> consistencyOffsetVector;
    private final Optional<KsqlHostInfo> sourceNode;

    public static RowMetadata of(PushOffsetRange pushOffsetsRange) {
        return new RowMetadata(Optional.of(pushOffsetsRange), Optional.empty(), Optional.empty());
    }

    public static RowMetadata of(ConsistencyOffsetVector consistencyOffsetVector) {
        return new RowMetadata(Optional.empty(), Optional.of(consistencyOffsetVector), Optional.empty());
    }

    public static RowMetadata of(KsqlHostInfo sourceNode) {
        return new RowMetadata(Optional.empty(), Optional.empty(), Optional.of(sourceNode));
    }

    private RowMetadata(Optional<PushOffsetRange> pushOffsetsRange, Optional<ConsistencyOffsetVector> consistencyOffsetVector, Optional<KsqlHostInfo> sourceNode) {
        this.pushOffsetsRange = pushOffsetsRange;
        this.consistencyOffsetVector = consistencyOffsetVector;
        this.sourceNode = sourceNode;
    }

    public Optional<PushOffsetRange> getPushOffsetsRange() {
        return this.pushOffsetsRange;
    }

    public Optional<ConsistencyOffsetVector> getConsistencyOffsetVector() {
        return this.consistencyOffsetVector;
    }

    public Optional<KsqlHostInfo> getSourceNode() {
        return this.sourceNode;
    }

    public boolean isStandaloneRow() {
        return this.pushOffsetsRange.isPresent() || this.consistencyOffsetVector.isPresent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowMetadata rowMetadata = (RowMetadata)o;
        return Objects.equals(this.pushOffsetsRange, rowMetadata.pushOffsetsRange) && Objects.equals(this.consistencyOffsetVector, rowMetadata.consistencyOffsetVector);
    }

    public int hashCode() {
        return Objects.hash(this.pushOffsetsRange, this.consistencyOffsetVector);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RowMetadata{");
        sb.append("pushOffsetsRange=").append(this.pushOffsetsRange);
        sb.append(", consistencyOffsetVector=").append(this.consistencyOffsetVector);
        sb.append('}');
        return sb.toString();
    }
}

