/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class IteratorUtil {
    private IteratorUtil() {
    }

    public static <T> Iterator<T> onComplete(Iterator<T> iterator, Runnable runnable) {
        return new IteratorWithCallbacks<T>(iterator, runnable);
    }

    @SafeVarargs
    public static <T> Iterator<T> of(T ... elements) {
        return ImmutableList.copyOf((Object[])elements).iterator();
    }

    private static class IteratorWithCallbacks<T>
    implements Iterator<T> {
        private final Iterator<T> backingIterator;
        private final Runnable completeRunnable;
        private boolean completeCalled = false;

        IteratorWithCallbacks(Iterator<T> backingIterator, Runnable completeRunnable) {
            this.backingIterator = backingIterator;
            this.completeRunnable = completeRunnable;
        }

        @Override
        public boolean hasNext() {
            if (this.completeCalled) {
                return false;
            }
            boolean hasNext = this.backingIterator.hasNext();
            this.maybeCallComplete(hasNext);
            return hasNext;
        }

        @Override
        public T next() {
            try {
                return this.backingIterator.next();
            }
            catch (NoSuchElementException e) {
                this.maybeCallComplete(false);
                throw e;
            }
        }

        private void maybeCallComplete(boolean hasNext) {
            if (!hasNext && !this.completeCalled) {
                this.completeCalled = true;
                this.completeRunnable.run();
            }
        }
    }
}

