/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.util.CompatibleSet;
import java.util.Set;

@Immutable
public final class SerdeFeatures
extends CompatibleSet<SerdeFeature> {
    public static final ImmutableSet<SerdeFeature> WRAPPING_FEATURES = ImmutableSet.of((Object)SerdeFeature.WRAP_SINGLES, (Object)SerdeFeature.UNWRAP_SINGLES);

    @JsonCreator
    public static SerdeFeatures from(Set<SerdeFeature> features) {
        return new SerdeFeatures(features);
    }

    public static SerdeFeatures of(SerdeFeature ... features) {
        return new SerdeFeatures((Set<SerdeFeature>)ImmutableSet.copyOf((Object[])features));
    }

    private SerdeFeatures(Set<SerdeFeature> features) {
        super(features);
    }

    public boolean enabled(SerdeFeature feature) {
        return this.contains(feature);
    }

    @Override
    @JsonValue
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="incompatibleWith is ImmutableSet")
    public Set<SerdeFeature> all() {
        return this.values;
    }

    public static final class NOT_EMPTY {
        @SuppressFBWarnings(value={"EQ_CHECK_FOR_OPERAND_NOT_COMPATIBLE_WITH_THIS", "EQ_UNUSUAL"})
        public boolean equals(Object obj) {
            if (!(obj instanceof SerdeFeatures)) {
                return false;
            }
            return ((SerdeFeatures)obj).values.isEmpty();
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

