/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.properties;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.confluent.ksql.config.PropertyParser;
import io.confluent.ksql.properties.LocalPropertyParser;
import io.confluent.ksql.properties.PropertyNotFoundException;
import io.confluent.ksql.util.KsqlException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class PropertiesUtil {
    private static final PropertyParser PROPERTY_PARSER = new LocalPropertyParser();
    private static final Set<Predicate<String>> BLACK_LIST = ImmutableSet.builder().add(key -> key.startsWith("java.")).add(key -> key.startsWith("os.")).add(key -> key.startsWith("sun.")).add(key -> key.startsWith("user.")).add(key -> key.startsWith("line.separator")).add(key -> key.startsWith("path.separator")).add(key -> key.startsWith("file.separator")).build();
    private static final Predicate<String> IS_BLACKLISTED = BLACK_LIST.stream().reduce(key -> false, Predicate::or);
    private static final Predicate<String> NOT_BLACKLISTED = IS_BLACKLISTED.negate();

    private PropertiesUtil() {
    }

    public static Properties asProperties(Map<String, ?> mapProps) {
        Properties properties = new Properties();
        properties.putAll(mapProps);
        return properties;
    }

    public static Map<String, String> loadProperties(File propertiesFile) {
        return PropertiesUtil.loadProperties((List<File>)ImmutableList.of((Object)propertiesFile));
    }

    public static Map<String, String> loadProperties(List<File> propertiesFiles) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (File propertiesFile : propertiesFiles) {
            properties.putAll(PropertiesUtil.loadPropsFromFile(propertiesFile));
        }
        PropertiesUtil.throwOnBlackListedProperties(properties);
        return ImmutableMap.copyOf(properties);
    }

    public static Map<String, String> toMapStrings(Map<String, Object> props) {
        HashMap<String, String> stringsProps = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            stringsProps.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return stringsProps;
    }

    public static Map<String, String> applyOverrides(Map<String, String> props, Properties overrides) {
        Map<String, String> overridesMap = PropertiesUtil.asMap(overrides);
        HashMap<String, String> merged = new HashMap<String, String>(props);
        merged.putAll(PropertiesUtil.filterByKey(overridesMap, NOT_BLACKLISTED));
        return ImmutableMap.copyOf(merged);
    }

    public static Map<String, String> filterByKey(Map<String, String> props, Predicate<String> predicate) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        props.entrySet().stream().filter(e -> predicate.test((String)e.getKey())).forEach(e -> builder.put(e.getKey(), e.getValue()));
        return builder.build();
    }

    private static Map<String, String> loadPropsFromFile(File propertiesFile) {
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(propertiesFile);){
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new KsqlException("Failed to load properties file: " + propertiesFile);
        }
        return PropertiesUtil.asMap(properties);
    }

    private static void throwOnBlackListedProperties(Map<String, ?> properties) {
        String separator = System.lineSeparator() + "\t- ";
        String blacklisted = properties.keySet().stream().filter(IS_BLACKLISTED).collect(Collectors.joining(separator));
        if (!blacklisted.isEmpty()) {
            throw new KsqlException("Property file contains the following blacklisted properties (Please remove them an try again):" + separator + blacklisted);
        }
    }

    private static Map<String, String> asMap(Properties props) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        props.stringPropertyNames().forEach(key -> builder.put(key, (Object)props.getProperty((String)key)));
        return builder.build();
    }

    public static Map<String, Object> coerceTypes(Map<String, Object> streamsProperties, boolean ignoreUnresolved) {
        if (streamsProperties == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> validated = new HashMap<String, Object>(streamsProperties.size());
        for (Map.Entry<String, Object> e : streamsProperties.entrySet()) {
            try {
                validated.put(e.getKey(), PropertiesUtil.coerceType(e.getKey(), e.getValue()));
            }
            catch (PropertyNotFoundException p) {
                if (ignoreUnresolved) {
                    validated.put(e.getKey(), e.getValue());
                    continue;
                }
                throw p;
            }
        }
        return validated;
    }

    private static Object coerceType(String key, Object value) {
        try {
            String stringValue = value == null ? null : (value instanceof List ? PropertiesUtil.listToString((List)value) : String.valueOf(value));
            return PROPERTY_PARSER.parse(key, stringValue);
        }
        catch (PropertyNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KsqlException("Failed to coerce type of value '" + value + "' for key '" + key + "'", e);
        }
    }

    private static String listToString(List<?> value) {
        return value.stream().map(e -> e == null ? null : e.toString()).collect(Collectors.joining(","));
    }
}

