/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser;

import com.google.errorprone.annotations.Immutable;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class NodeLocation {
    private final int line;
    private final int charPositionInLine;

    public NodeLocation(int line, int charPositionInLine) {
        this.line = line;
        this.charPositionInLine = charPositionInLine;
    }

    public int getStartLineNumber() {
        return this.getLineNumber();
    }

    public int getStartColumnNumber() {
        return this.getColumnNumber();
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.charPositionInLine + 1;
    }

    public String asPrefix() {
        return this.toString() + ": ";
    }

    public static String asPrefix(Optional<NodeLocation> location) {
        return location.map(NodeLocation::asPrefix).orElse("");
    }

    public String toString() {
        return String.format("Line: %d, Col: %d", this.line, this.charPositionInLine + 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeLocation that = (NodeLocation)o;
        return this.line == that.line && this.charPositionInLine == that.charPositionInLine;
    }

    public int hashCode() {
        return Objects.hash(this.line, this.charPositionInLine);
    }
}

