/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.logging.processing;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import java.util.Objects;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;

public class MeteredProcessingLogger
implements ProcessingLogger {
    private final ProcessingLogger logger;
    private final Metrics metrics;
    private final Sensor errorSensor;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public MeteredProcessingLogger(ProcessingLogger logger, Metrics metrics, Sensor errorSensor) {
        this.logger = Objects.requireNonNull(logger, "logger");
        this.metrics = metrics;
        this.errorSensor = errorSensor;
    }

    @Override
    public void error(ProcessingLogger.ErrorMessage msg) {
        if (this.errorSensor != null) {
            this.errorSensor.record();
        }
        this.logger.error(msg);
    }

    @Override
    public void close() {
        if (this.metrics != null) {
            this.metrics.removeSensor(this.errorSensor.name());
        }
        this.logger.close();
    }
}

