/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.function.AggregateFunctionInitArguments;
import io.confluent.ksql.function.FunctionSignature;
import io.confluent.ksql.function.KsqlAggregateFunction;
import io.confluent.ksql.function.types.DecimalType;
import io.confluent.ksql.function.types.ParamType;
import io.confluent.ksql.function.types.ParamTypes;
import io.confluent.ksql.function.udf.UdfMetadata;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.types.SqlDecimal;
import io.confluent.ksql.schema.ksql.types.SqlType;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class AggregateFunctionFactory {
    private final UdfMetadata metadata;
    protected static final ImmutableList<List<ParamType>> NUMERICAL_ARGS = ImmutableList.builder().add((Object)ImmutableList.of((Object)ParamTypes.INTEGER)).add((Object)ImmutableList.of((Object)ParamTypes.LONG)).add((Object)ImmutableList.of((Object)ParamTypes.DOUBLE)).add((Object)ImmutableList.of((Object)ParamTypes.DECIMAL)).build();
    protected static final ImmutableList<List<ParamType>> NUMERICAL_TIME = ImmutableList.builder().addAll(NUMERICAL_ARGS).add((Object)ImmutableList.of((Object)ParamTypes.DATE)).add((Object)ImmutableList.of((Object)ParamTypes.TIME)).add((Object)ImmutableList.of((Object)ParamTypes.TIMESTAMP)).build();
    protected static final ImmutableList<List<ParamType>> COMPARABLE_ARGS = ImmutableList.builder().addAll(NUMERICAL_TIME).add((Object)ImmutableList.of((Object)ParamTypes.STRING)).add((Object)ImmutableList.of((Object)ParamTypes.BYTES)).build();

    public AggregateFunctionFactory(String functionName) {
        this(new UdfMetadata(functionName, "", "Confluent", "", "AGGREGATE", "internal"));
    }

    public AggregateFunctionFactory(UdfMetadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata can't be null");
    }

    public abstract FunctionSource getFunction(List<SqlType> var1);

    protected abstract List<List<ParamType>> supportedArgs();

    public UdfMetadata getMetadata() {
        return this.metadata;
    }

    public String getName() {
        return this.metadata.getName();
    }

    public void eachFunction(BiConsumer<FunctionSignature, String> consumer) {
        this.supportedArgs().stream().map(args -> args.stream().map(AggregateFunctionFactory::getSampleSqlType).collect(Collectors.toList())).forEach(args -> {
            KsqlAggregateFunction<?, ?, ?> function = this.getFunction((List<SqlType>)args).source.apply(this.getDefaultArguments());
            consumer.accept(function, function.getDescription());
        });
    }

    private static SqlType getSampleSqlType(ParamType paramType) {
        if (paramType instanceof DecimalType) {
            return SqlDecimal.of((int)2, (int)1);
        }
        return SchemaConverters.functionToSqlConverter().toSqlType(paramType);
    }

    public AggregateFunctionInitArguments getDefaultArguments() {
        return AggregateFunctionInitArguments.EMPTY_ARGS;
    }

    public static class FunctionSource {
        public final int initArgs;
        public final Function<AggregateFunctionInitArguments, KsqlAggregateFunction<?, ?, ?>> source;

        public FunctionSource(int initArgs, Function<AggregateFunctionInitArguments, KsqlAggregateFunction<?, ?, ?>> source) {
            this.initArgs = initArgs;
            this.source = source;
        }
    }
}

