/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.errors;

import io.confluent.ksql.logging.processing.ProcessingLogConfig;
import io.confluent.ksql.logging.processing.ProcessingLogMessageSchema;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.streams.errors.ProductionExceptionHandler;

public final class ProductionExceptionHandlerUtil {
    public static final String KSQL_PRODUCTION_ERROR_LOGGER = "ksql.logger.production.error";

    private ProductionExceptionHandlerUtil() {
    }

    public static Class<?> getHandler(boolean failOnError) {
        return failOnError ? LogAndFailProductionExceptionHandler.class : LogAndContinueProductionExceptionHandler.class;
    }

    public static class LogAndContinueProductionExceptionHandler
    extends LogAndXProductionExceptionHandler {
        @Override
        ProductionExceptionHandler.ProductionExceptionHandlerResponse getResponse() {
            return ProductionExceptionHandler.ProductionExceptionHandlerResponse.CONTINUE;
        }
    }

    public static class LogAndFailProductionExceptionHandler
    extends LogAndXProductionExceptionHandler {
        @Override
        ProductionExceptionHandler.ProductionExceptionHandlerResponse getResponse() {
            return ProductionExceptionHandler.ProductionExceptionHandlerResponse.FAIL;
        }
    }

    public static final class ProductionError
    implements ProcessingLogger.ErrorMessage {
        private final String errorMsg;

        public ProductionError(String errorMsg) {
            this.errorMsg = errorMsg == null ? "" : errorMsg;
        }

        @Override
        public SchemaAndValue get(ProcessingLogConfig config) {
            Struct struct = new Struct(ProcessingLogMessageSchema.PROCESSING_LOG_SCHEMA).put("type", (Object)ProcessingLogMessageSchema.MessageType.PRODUCTION_ERROR.getTypeId()).put("productionError", (Object)this.productionError());
            return new SchemaAndValue(ProcessingLogMessageSchema.PROCESSING_LOG_SCHEMA, (Object)struct);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProductionError that = (ProductionError)o;
            return Objects.equals(this.errorMsg, that.errorMsg);
        }

        public int hashCode() {
            return Objects.hash(this.errorMsg);
        }

        private Struct productionError() {
            return new Struct(ProcessingLogMessageSchema.MessageType.PRODUCTION_ERROR.getSchema()).put("errorMessage", (Object)this.errorMsg);
        }
    }

    static abstract class LogAndXProductionExceptionHandler
    implements ProductionExceptionHandler {
        private ProcessingLogger logger;

        LogAndXProductionExceptionHandler() {
        }

        public ProductionExceptionHandler.ProductionExceptionHandlerResponse handle(ProducerRecord<byte[], byte[]> record, Exception exception) {
            this.logger.error(new ProductionError(exception.getMessage()));
            return this.getResponse();
        }

        public void configure(Map<String, ?> configs) {
            Object logger = configs.get(ProductionExceptionHandlerUtil.KSQL_PRODUCTION_ERROR_LOGGER);
            if (!(logger instanceof ProcessingLogger)) {
                throw new IllegalArgumentException("Invalid value for logger: " + logger.toString());
            }
            this.logger = (ProcessingLogger)logger;
        }

        abstract ProductionExceptionHandler.ProductionExceptionHandlerResponse getResponse();
    }
}

